/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.util.sftp;

import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.kodi.common.util.sftp.SftpFileWrapper;
import com.myapp.util.file.RecursiveTreeIterator;
import java.util.List;
import java.util.stream.Collectors;

public class SftpFileNode
implements RecursiveTreeIterator.TreeNode<SftpFileWrapper>,
Comparable<SftpFileNode> {
    private SftpFileWrapper wrapper;

    public SftpFileNode(SftpFileWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public List<RecursiveTreeIterator.TreeNode<SftpFileWrapper>> getChildren() {
        if (this.wrapper.isFile()) {
            return null;
        }
        SftpFileWrapper value = this.getValue();
        List<IFileWrapper> smbFiles = value.listFiles();
        if (smbFiles == null || smbFiles.isEmpty()) {
            return null;
        }
        return smbFiles.stream().filter(f -> !f.getName().equals(".") && !f.getName().equals("..") && !f.getPath().equals(this.wrapper.getPath())).map(f -> {
            SftpFileWrapper w = f.isFile() && f instanceof SftpFileWrapper ? (SftpFileWrapper)f : new SftpFileWrapper(this.wrapper.getSftpConnectionManager(), f.getURLAsString());
            return new SftpFileNode(w);
        }).sorted().collect(Collectors.toList());
    }

    public SftpFileWrapper getValue() {
        return this.wrapper;
    }

    @Override
    public int compareTo(SftpFileNode o) {
        return this.getValue().compareTo(o.getValue());
    }
}

