/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.util.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.myapp.kodi.common.util.sftp.SftpConnectionManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

class SftpConnectionPool {
    private static final Pattern SFTP_URL_PATTERN = Pattern.compile("(?ix) ^ sftp:// ([^:]+) : ([^@]+) @ ([^:]+) (:[0-9]+) // .* $");
    private static final Logger logger = Logger.getLogger(SftpConnectionPool.class);
    private final SftpConnectionManager util;
    private String username;
    private String password;
    private String hostname;
    private int port = 22;
    private Session sshSession = null;
    private Set<ChannelSftp> activeChannels = null;
    private Set<ChannelSftp> passiveChannels = null;

    public SftpConnectionPool(String url, SftpConnectionManager util) {
        Matcher m = SFTP_URL_PATTERN.matcher(url);
        if (!m.find()) {
            throw new RuntimeException(url);
        }
        this.username = m.group(1);
        this.password = m.group(2);
        this.hostname = m.group(3);
        String portString = m.group(4);
        if (StringUtils.isNotBlank((CharSequence)portString)) {
            portString = portString.substring(1);
            this.port = Integer.parseInt(portString);
        }
        this.util = util;
    }

    public static String getKeyFromUrl(String url) {
        Matcher m = SFTP_URL_PATTERN.matcher(url);
        if (!m.find()) {
            throw new RuntimeException(url);
        }
        String username = m.group(1);
        String hostname = m.group(3);
        String portString = m.group(4);
        if (StringUtils.isBlank((CharSequence)portString)) {
            portString = ":22";
        }
        return username + "@" + hostname + portString;
    }

    public String getKey() {
        return this.username + "@" + this.hostname + ":" + this.port;
    }

    public String toString() {
        return "Pool[" + this.getKey() + "]@" + this.hashCode();
    }

    public ChannelSftp aquireChannel() {
        ChannelSftp channel;
        if (!this.isConnected()) {
            JSch ssh = new JSch();
            try {
                byte[] knownHosts = this.util.readKnownHosts();
                ssh.setKnownHosts((InputStream)new ByteArrayInputStream(knownHosts));
                this.sshSession = ssh.getSession(this.username, this.hostname, this.port);
                this.sshSession.setPassword(this.password);
                this.sshSession.connect();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Session established to " + this.getKey()));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(this.getKey(), e);
            }
        }
        if (CollectionUtils.isNotEmpty(this.passiveChannels)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reusing sftp channel to " + this.getKey()));
            }
            Iterator<ChannelSftp> iterator = this.passiveChannels.iterator();
            channel = iterator.next();
            iterator.remove();
        } else {
            try {
                channel = (ChannelSftp)this.sshSession.openChannel("sftp");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Create new sftp channel to " + this.getKey()));
                }
                channel.connect();
            }
            catch (JSchException e) {
                throw new RuntimeException(this.getKey(), e);
            }
        }
        if (this.activeChannels == null) {
            this.activeChannels = new HashSet<ChannelSftp>();
        }
        this.activeChannels.add(channel);
        return channel;
    }

    public boolean isConnected() {
        return this.sshSession != null && this.sshSession.isConnected();
    }

    public void passivateChannel(ChannelSftp channel) {
        this.activeChannels.remove(channel);
        if (this.passiveChannels == null) {
            this.passiveChannels = new HashSet<ChannelSftp>();
        }
        this.passiveChannels.add(channel);
    }

    public void destroy() {
        int active = this.activeChannels == null ? 0 : this.activeChannels.size();
        int passive = this.passiveChannels == null ? 0 : this.passiveChannels.size();
        logger.info((Object)("Disconnecting ssh session to " + this.getKey() + " - closing " + active + " active and " + passive + " passive channels."));
        if (active > 0) {
            logger.warn((Object)("Closing " + active + " active sessions to " + this.getKey() + " that have not been passivated."));
        }
        if (active > 0) {
            this.activeChannels.forEach(ChannelSftp::disconnect);
        }
        if (passive > 0) {
            this.passiveChannels.forEach(ChannelSftp::disconnect);
        }
        if (this.isConnected()) {
            this.sshSession.disconnect();
        }
    }
}

