/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.util.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.myapp.kodi.common.util.sftp.SftpConnectionPool;
import com.myapp.kodi.common.util.sftp.SftpFileWrapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SftpConnectionManager {
    private static final Logger logger = Logger.getLogger(SftpFileWrapper.class);
    private static boolean sftpUrlStreamHandlerRegistered = false;
    private byte[] cachedKnownHostsBytes = null;
    private URL knownHostsResource = null;
    private final Map<String, SftpConnectionPool> pools = new LinkedHashMap<String, SftpConnectionPool>();

    public SftpConnectionManager() {
        SftpConnectionManager.registerSftpUrlStreamHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelSftp aquireSftpChannel(String url) {
        logger.info((Object)("Aquiring sftp channel for " + url));
        String key = SftpConnectionPool.getKeyFromUrl(url);
        Map<String, SftpConnectionPool> map = this.pools;
        synchronized (map) {
            SftpConnectionPool existingPool = this.pools.get(key);
            if (existingPool == null) {
                existingPool = new SftpConnectionPool(url, this);
                this.pools.put(key, existingPool);
            }
            return existingPool.aquireChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivateSftpChannel(String url, ChannelSftp channelSftp) {
        logger.info((Object)("Passivating sftp channel used for " + url));
        Map<String, SftpConnectionPool> map = this.pools;
        synchronized (map) {
            String key = SftpConnectionPool.getKeyFromUrl(url);
            SftpConnectionPool pool = this.pools.get(key);
            pool.passivateChannel(channelSftp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readKnownHosts() {
        if (this.cachedKnownHostsBytes != null) {
            return new byte[0];
        }
        SftpConnectionManager sftpConnectionManager = this;
        synchronized (sftpConnectionManager) {
            if (this.cachedKnownHostsBytes != null) {
                return new byte[0];
            }
            URL url = this.knownHostsResource == null ? SftpConnectionManager.class.getClassLoader().getResource("known_hosts") : this.knownHostsResource;
            if (url == null) {
                throw new RuntimeException("known hosts file is not specified");
            }
            ByteArrayOutputStream array = new ByteArrayOutputStream();
            try {
                IOUtils.copy((InputStream)url.openStream(), (OutputStream)array);
            }
            catch (Exception e) {
                throw new RuntimeException("error reading " + url, e);
            }
            logger.info((Object)("Known hosts file read from resource: " + url));
            this.cachedKnownHostsBytes = array.toByteArray();
            return this.cachedKnownHostsBytes;
        }
    }

    public void setKnownHostsResource(URL knownHostsResource) {
        this.knownHostsResource = knownHostsResource;
    }

    public void setKnownHostsFile(File resource) {
        try {
            this.knownHostsResource = resource.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid resource: " + resource, e);
        }
    }

    public void closeAllConnections() {
        this.pools.values().forEach(SftpConnectionPool::destroy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSftpUrlStreamHandler() {
        if (sftpUrlStreamHandlerRegistered) {
            return;
        }
        Class<SftpFileWrapper> clazz = SftpFileWrapper.class;
        synchronized (SftpFileWrapper.class) {
            if (sftpUrlStreamHandlerRegistered) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            URL.setURLStreamHandlerFactory(protocol -> {
                if ("sftp".equals(protocol)) {
                    return new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) {
                            return new URLConnection(u){

                                @Override
                                public void connect() {
                                }
                            };
                        }
                    };
                }
                return null;
            });
            sftpUrlStreamHandlerRegistered = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

