/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.util;

import com.myapp.kodi.common.domain.Movie;
import com.myapp.kodi.common.util.IFileWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PathBasedRule
implements Predicate<Movie> {
    private List<Pair<Rule, List<String>>> rules = new ArrayList<Pair<Rule, List<String>>>();

    public PathBasedRule add(Rule rule, String ... array) {
        if (array.length <= 0) {
            throw new IllegalArgumentException("empty search term list");
        }
        this.rules.add((Pair<Rule, List<String>>)new ImmutablePair((Object)rule, Arrays.asList(array)));
        return this;
    }

    @Override
    public boolean test(Movie movie) {
        List<IFileWrapper> smbFiles = movie.getSmbFiles();
        List<String> paths = smbFiles.stream().map(IFileWrapper::getPath).collect(Collectors.toList());
        for (Pair<Rule, List<String>> ruleSet : this.rules) {
            List searchList = (List)ruleSet.getValue();
            Rule rule = (Rule)((Object)ruleSet.getKey());
            if (PathBasedRule.testRule(rule, searchList, paths)) continue;
            return false;
        }
        return true;
    }

    private static boolean testRule(Rule rule, List<String> searchTerms, List<String> input) {
        switch (rule) {
            case mustNotContainAllOf: {
                boolean allFound = true;
                for (String search : searchTerms) {
                    if (PathBasedRule.isFound(input, search)) continue;
                    allFound = false;
                    break;
                }
                if (!allFound) break;
                return false;
            }
            case requireAnyOf: {
                boolean anyFound = false;
                for (String search : searchTerms) {
                    if (!PathBasedRule.isFound(input, search)) continue;
                    anyFound = true;
                    break;
                }
                if (anyFound) break;
                return false;
            }
            case mustNotContainAnyOf: {
                for (String search : searchTerms) {
                    if (!PathBasedRule.isFound(input, search)) continue;
                    return false;
                }
                break;
            }
            case requireAllOf: {
                for (String search : searchTerms) {
                    if (PathBasedRule.isFound(input, search)) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    private static boolean isFound(List<String> list, String search) {
        boolean found = false;
        for (String path : list) {
            if (!path.contains(search)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static enum Rule {
        requireAllOf,
        requireAnyOf,
        mustNotContainAnyOf,
        mustNotContainAllOf;

    }
}

