/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.stream.Stream;

public interface IFileWrapper
extends Comparable<IFileWrapper> {
    public String getName();

    public String getPath();

    public String getParent();

    public boolean isDirectory();

    public boolean isFile();

    public List<IFileWrapper> listFiles();

    public long getLength();

    public InputStream getInputStream() throws IOException;

    public URL getURL();

    public String getURLAsString();

    public IFileWrapper getParentWrapped();

    public Stream<IFileWrapper> streamChildrenRecursively();

    @Override
    default public int compareTo(IFileWrapper o) {
        boolean oIsDir;
        boolean thisIsDir = this.isDirectory();
        if (thisIsDir == (oIsDir = o.isDirectory())) {
            return String.valueOf(this.getURL()).compareTo(String.valueOf(o.getURL()));
        }
        return thisIsDir ? -1 : 1;
    }
}

