/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.service;

import com.myapp.kodi.common.domain.Video;
import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.kodi.common.util.smb.SmbToLocalFileMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SubtitleService {
    private static final Logger logger = Logger.getLogger(SubtitleService.class);
    private final SmbToLocalFileMapper fileMapper;

    @Autowired
    public SubtitleService(SmbToLocalFileMapper fileMapper) {
        this.fileMapper = fileMapper;
    }

    public boolean hasLocalSubtitle(IFileWrapper file) {
        String filePath = file.getPath();
        String filePathWithoutExt = StringUtils.stripFilenameExtension((String)filePath);
        if (filePathWithoutExt.equals(filePath)) {
            logger.warn((Object)("filename without extension!? " + filePath));
            return false;
        }
        if (this.hasEquallyNamedSubtitleFile(file)) {
            logger.debug((Object)("found equally named subtitle for:   " + filePath));
            return true;
        }
        if (this.hasEmbeddedSubtitleStream(file)) {
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("No subtitles found for " + filePath));
        }
        return false;
    }

    private boolean hasEquallyNamedSubtitleFile(IFileWrapper file) {
        String filePath = file.getPath();
        String filePathWithoutExt = StringUtils.stripFilenameExtension((String)filePath);
        List<IFileWrapper> siblings = file.getParentWrapped().listFiles();
        return siblings.stream().anyMatch(s -> {
            String sPath = s.getPath();
            if (sPath.equalsIgnoreCase(filePath)) {
                return false;
            }
            if (!sPath.toLowerCase().contains(filePathWithoutExt.toLowerCase())) {
                return false;
            }
            String ext = StringUtils.getFilenameExtension((String)sPath);
            if (ext == null) {
                logger.warn((Object)("filename without extension!? " + sPath));
                return false;
            }
            switch (ext.toLowerCase()) {
                case "sub": 
                case "srt": 
                case "sbv": 
                case "lrc": 
                case "mpsub": {
                    return true;
                }
            }
            return false;
        });
    }

    private boolean hasEmbeddedSubtitleStream(IFileWrapper file) {
        File fsFile = this.fileMapper.toLocalFile(file);
        BufferedReader r = null;
        try {
            String line;
            Process avconv = new ProcessBuilder(new String[0]).directory(fsFile.getParentFile()).command("avconv", "-i", fsFile.getName()).redirectErrorStream(true).start();
            avconv.waitFor();
            r = new BufferedReader(new InputStreamReader(avconv.getInputStream()));
            while ((line = r.readLine()) != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)line);
                }
                if (!(line = line.toLowerCase()).contains("stream") || !line.contains("subtitle") || !line.matches(".*\\ben(|g|lisc?h)\\b.*")) continue;
                logger.debug((Object)("found embedded subtitles in: " + file.getName() + " - " + line));
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(fsFile.getAbsolutePath(), e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public <V extends Video> List<V> getEnglishVideosWithoutSubs(Collection<V> englishVideos) {
        LocalDateTime start = LocalDateTime.now();
        AtomicInteger checked = new AtomicInteger();
        AtomicInteger haveSubs = new AtomicInteger();
        AtomicInteger noSubs = new AtomicInteger();
        List withoutSubtitles = englishVideos.parallelStream().filter(e -> {
            boolean hasNoSubtitle;
            Optional<IFileWrapper> optional = e.getFirstSmbFile();
            if (!optional.isPresent()) {
                logger.warn((Object)("every FileConnected instance should have a file: " + e));
                return false;
            }
            IFileWrapper file = optional.get();
            boolean bl = hasNoSubtitle = !this.hasLocalSubtitle(file);
            if (hasNoSubtitle) {
                noSubs.incrementAndGet();
            } else {
                haveSubs.incrementAndGet();
            }
            if (checked.incrementAndGet() % 100 == 0) {
                this.logStats(Duration.between(start, LocalDateTime.now()).toMillis(), englishVideos.size(), haveSubs, noSubs, checked);
            }
            return hasNoSubtitle;
        }).collect(Collectors.toList());
        this.logStats(Duration.between(start, LocalDateTime.now()).toMillis(), englishVideos.size(), haveSubs, noSubs, checked);
        return withoutSubtitles;
    }

    private void logStats(long durationMillis, int elementCount, Number have, Number haveNot, Number processed) {
        long milliPerElement = durationMillis / (long)processed.intValue();
        logger.info((Object)("Filtered " + elementCount + " elements in " + durationMillis + " ms. " + processed + " were processed, " + have + " elements had subs, " + haveNot + " didn't. speed " + milliPerElement + " ms/element"));
    }
}

