/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.service;

import com.myapp.kodi.common.domain.Episode;
import com.myapp.kodi.common.domain.Movie;
import com.myapp.kodi.common.domain.Tag;
import com.myapp.kodi.common.domain.TvShow;
import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.kodi.common.util.sftp.SftpConnectionManager;
import com.myapp.kodi.common.util.sftp.SftpFileWrapper;
import com.myapp.kodi.common.util.smb.SmbFileWrapper;
import com.myapp.kodi.impl.kodi_MyVideos99.entities.EpisodeEntity;
import com.myapp.kodi.impl.kodi_MyVideos99.entities.FileEntity;
import com.myapp.kodi.impl.kodi_MyVideos99.entities.MovieEntity;
import com.myapp.kodi.impl.kodi_MyVideos99.entities.PathEntity;
import com.myapp.kodi.impl.kodi_MyVideos99.entities.TagEntity;
import com.myapp.kodi.impl.kodi_MyVideos99.entities.TvShowEntity;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jcifs.smb.NtlmPasswordAuthentication;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class DomainObjectMapper {
    @Autowired(required=false)
    private SftpConnectionManager sftpConnectionManager;
    private static final Pattern STACKED_PATHS_PATTERN = Pattern.compile("(?ix) ( (?:smb|sftp):// .*? ) \\s* (?=( $ | , \\s* (?:smb|sftp):// ))");

    public Movie convert(MovieEntity me) {
        Integer year = DomainObjectMapper.parseIntegerIfPossible(me.getReleaseYear());
        Integer runtimeSecInt = DomainObjectMapper.parseIntegerIfPossible(me.getRuntimeSeconds());
        List<IFileWrapper> smbFiles = this.convert(me.getFile());
        List<Tag> tags = me.getTags().stream().map(this::convert).collect(Collectors.toList());
        Movie movie = new Movie(me.getIdMovie());
        movie.setTitle(me.getTitle());
        movie.setPlot(me.getPlot());
        movie.setReleaseYear(year == null ? -333 : year);
        movie.setImdbId(me.getImdbId());
        movie.setSmbFiles(smbFiles);
        movie.setRuntimeSeconds(runtimeSecInt == null ? -333 : runtimeSecInt);
        movie.setOriginalTitle(me.getOriginalTitle());
        movie.setTags(tags);
        return movie;
    }

    private Episode convert(EpisodeEntity ee) {
        Integer season = DomainObjectMapper.parseIntegerIfPossible(ee.getSeason());
        Integer episodeNr = DomainObjectMapper.parseIntegerIfPossible(ee.getEpisode());
        List<IFileWrapper> smbFiles = this.convert(ee.getFile());
        Episode episode = new Episode(ee.getIdEpisode());
        episode.setTitle(ee.getTitle());
        episode.setSeason(season == null ? -333 : season);
        episode.setEpisodeNr(episodeNr == null ? -333 : episodeNr);
        episode.setSmbFiles(smbFiles);
        episode.setPlot(ee.getPlot());
        return episode;
    }

    public TvShow convert(TvShowEntity tve) {
        Integer year = DomainObjectMapper.parseIntegerIfPossible(tve.getFirstAired());
        TvShow show = new TvShow(tve.getIdShow());
        show.setTitle(tve.getTitle());
        show.setPlot(tve.getPlot());
        show.setFirsAired(year == null ? -333 : year);
        tve.getEpisodes().stream().map(this::convert).forEach(show::addEpisode);
        return show;
    }

    public IFileWrapper convert(PathEntity pathEntity) {
        String strPath = StringUtils.trimToEmpty((String)pathEntity.getStrPath());
        if (!StringUtils.startsWithIgnoreCase((CharSequence)strPath, (CharSequence)"smb://") && !StringUtils.startsWithIgnoreCase((CharSequence)strPath, (CharSequence)"sftp://")) {
            return null;
        }
        return this.createFileWrapper(strPath);
    }

    private List<IFileWrapper> convert(FileEntity fileEntity) {
        if (fileEntity == null) {
            return Collections.emptyList();
        }
        String strFilename = fileEntity.getStrFilename();
        if (StringUtils.isBlank((CharSequence)strFilename)) {
            return Collections.emptyList();
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)strFilename, (CharSequence)"stack://")) {
            Matcher m = STACKED_PATHS_PATTERN.matcher(strFilename);
            if (!m.find()) {
                throw new RuntimeException("stack but not containing paths: " + strFilename);
            }
            LinkedList<IFileWrapper> list = new LinkedList<IFileWrapper>();
            do {
                String smbPath = m.group(1);
                list.add(this.createFileWrapper(smbPath));
            } while (m.find());
            return Collections.unmodifiableList(list);
        }
        String strPath = fileEntity.getPath().getStrPath();
        if (!strPath.endsWith("/")) {
            strPath = strPath + "/";
        }
        strPath = strPath + strFilename;
        IFileWrapper singleFile = this.createFileWrapper(strPath);
        return Collections.singletonList(singleFile);
    }

    public Tag convert(TagEntity tag) {
        Tag t = new Tag(tag.getTagId());
        t.setName(tag.getName());
        return t;
    }

    private static Integer parseIntegerIfPossible(String intString) {
        return StringUtils.isNumeric((CharSequence)intString) ? Integer.valueOf(Integer.parseInt(intString)) : null;
    }

    public IFileWrapper createFileWrapper(String url) {
        if (url.startsWith("smb://")) {
            return new SmbFileWrapper(url, NtlmPasswordAuthentication.ANONYMOUS);
        }
        if (url.startsWith("sftp://")) {
            return new SftpFileWrapper(this.sftpConnectionManager, url);
        }
        throw new UnsupportedOperationException("unknown file type: '" + url + "'");
    }
}

