/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.domain;

import com.myapp.kodi.common.domain.AbstractDomainObject;
import com.myapp.kodi.common.domain.Episode;
import com.myapp.kodi.common.domain.Tag;
import com.myapp.kodi.common.domain.Titled;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class TvShow
extends AbstractDomainObject
implements Titled {
    private String title;
    private String plot;
    private int firsAired;
    private SortedSet<Episode> episodes = new TreeSet<Episode>();
    private List<Tag> tags;

    public TvShow(int id) {
        super(id);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    @Override
    public String getPlot() {
        return this.plot;
    }

    public void setFirsAired(int firsAired) {
        this.firsAired = firsAired;
    }

    public int getFirsAired() {
        return this.firsAired;
    }

    public void addEpisode(Episode episode) {
        episode.setTvShow(this);
    }

    public void removeEpisode(Episode episode) {
        episode.setTvShow(null);
    }

    public List<Episode> getEpisodes() {
        return new ArrayList<Episode>(this.episodes);
    }

    void internalAddEpisode(Episode episode) {
        this.episodes.add(episode);
    }

    void internalRemoveEpisode(Episode episode) {
        this.episodes.remove(episode);
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public String toString() {
        return "Tvs " + this.getIdToString() + " '" + this.getTitleToString() + "' episodes: " + (this.episodes == null || this.episodes.isEmpty() ? 0 : this.episodes.size());
    }
}

