/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.domain;

import com.myapp.kodi.common.domain.AbstractDomainObject;
import com.myapp.kodi.common.domain.Tag;
import com.myapp.kodi.common.domain.Video;
import com.myapp.kodi.common.util.IFileWrapper;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Movie
extends AbstractDomainObject
implements Video,
Comparable<Movie> {
    private String title;
    private String originalTitle;
    private String plot;
    private int releaseYear;
    private String imdbId;
    private List<IFileWrapper> smbFiles;
    private int runtimeSeconds;
    private List<Tag> tags;

    public Movie(int id) {
        super(id);
    }

    @Override
    public List<IFileWrapper> getSmbFiles() {
        return this.smbFiles;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    @Override
    public String getPlot() {
        return this.plot;
    }

    public void setReleaseYear(int releaseYear) {
        this.releaseYear = releaseYear;
    }

    public int getReleaseYear() {
        return this.releaseYear;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public String getImdbId() {
        return this.imdbId;
    }

    public void setSmbFiles(List<IFileWrapper> smbFiles) {
        this.smbFiles = smbFiles;
    }

    public void setRuntimeSeconds(int runtimeSeconds) {
        this.runtimeSeconds = runtimeSeconds;
    }

    public int getRuntimeSeconds() {
        return this.runtimeSeconds;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    @Override
    public int compareTo(Movie o) {
        if (this.equals(o)) {
            return 0;
        }
        int cmp = Objects.compare(this.title, o.title, String.CASE_INSENSITIVE_ORDER);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(this.releaseYear, o.releaseYear);
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(this.getId(), o.getId());
    }

    public boolean hasTag(String tagName) {
        if (StringUtils.isBlank((CharSequence)tagName)) {
            throw new RuntimeException();
        }
        return this.tags.stream().anyMatch(t -> t.getName().equals(tagName));
    }

    public String toString() {
        return this.getTitle() + " (" + this.getReleaseYear() + ") id: " + this.getId() + ", files: " + this.getSmbFilesToString();
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = originalTitle;
    }
}

