/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi.common.domain;

import com.myapp.kodi.common.domain.AbstractDomainObject;
import com.myapp.kodi.common.domain.TvShow;
import com.myapp.kodi.common.domain.Video;
import com.myapp.kodi.common.util.IFileWrapper;
import java.util.List;

public class Episode
extends AbstractDomainObject
implements Video,
Comparable<Episode> {
    private String title;
    private List<IFileWrapper> smbFiles;
    private TvShow tvShow;
    private int season;
    private int episodeNr;
    private String plot;

    public Episode(int id) {
        super(id);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<IFileWrapper> getSmbFiles() {
        return this.smbFiles;
    }

    public void setSmbFiles(List<IFileWrapper> smbFiles) {
        this.smbFiles = smbFiles;
    }

    public void setTvShow(TvShow tvShow) {
        if (this.tvShow != null) {
            this.tvShow.internalRemoveEpisode(this);
        }
        this.tvShow = tvShow;
        if (tvShow != null) {
            tvShow.internalAddEpisode(this);
        }
    }

    public TvShow getTvShow() {
        return this.tvShow;
    }

    public void setSeason(int season) {
        this.season = season;
    }

    public int getSeason() {
        return this.season;
    }

    public void setEpisodeNr(int episodeNr) {
        this.episodeNr = episodeNr;
    }

    public int getEpisodeNr() {
        return this.episodeNr;
    }

    @Override
    public int compareTo(Episode b) {
        Episode a = this;
        int cmp = Integer.compare(a.getSeason(), b.getSeason());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(a.getEpisodeNr(), b.getEpisodeNr());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(a.getId(), b.getId());
        return cmp;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    @Override
    public String getPlot() {
        return this.plot;
    }

    public String toString() {
        return "[" + this.tvShow.getTitle() + " " + this.season + "x" + this.episodeNr + "]";
    }
}

