/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi;

import com.myapp.kodi.App;
import com.myapp.kodi.common.domain.Movie;
import com.myapp.kodi.common.domain.Video;
import com.myapp.kodi.common.util.IFileWrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

class PrintUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Logger logger = Logger.getLogger(PrintUtil.class);

    PrintUtil() {
    }

    static <T extends Video> Diff calcDifferences(Map<T, List<IFileWrapper>> filesPerItem, List<IFileWrapper> inFs) {
        Diff diff = new Diff();
        diff.dbFilesFlat = filesPerItem.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        diff.dbFilesUniq = new HashSet<IFileWrapper>(diff.dbFilesFlat);
        diff.fsFilesUniq = new HashSet<IFileWrapper>(inFs);
        Set<IFileWrapper> inDbButNotInFs = diff.inDbButNotInFs;
        inDbButNotInFs.addAll(diff.dbFilesUniq);
        inDbButNotInFs.removeAll(diff.fsFilesUniq);
        Set<IFileWrapper> inFsButNotInDb = diff.inFsButNotInDb;
        inFsButNotInDb.addAll(diff.fsFilesUniq);
        inFsButNotInDb.removeAll(diff.dbFilesUniq);
        return diff;
    }

    static <T extends Video> Diff showDifferences(String type, Map<T, List<IFileWrapper>> filesPerItem, List<IFileWrapper> inFs) {
        String prefix = type.toUpperCase() + ": ";
        Diff diff = PrintUtil.calcDifferences(filesPerItem, inFs);
        logger.info((Object)(prefix + "Show differences of files in database and in filesystem."));
        logger.info((Object)(prefix + "Files registered in database: " + diff.dbFilesUniq.size() + ", files found in filesystem: " + diff.fsFilesUniq.size()));
        LinkedHashMap itemsPerFile = new LinkedHashMap();
        filesPerItem.forEach((mediaItem, fileList) -> fileList.forEach(file -> itemsPerFile.computeIfAbsent(file, x -> new LinkedHashSet()).add(mediaItem)));
        if (diff.dbFilesUniq.size() != diff.dbFilesFlat.size()) {
            logger.warn((Object)(prefix + "FILES IN DATABASE MIGHT CONTAIN DUPLICATES:"));
            LinkedHashMap<IFileWrapper, List> duplicatesMap = new LinkedHashMap<IFileWrapper, List>();
            for (IFileWrapper f2 : diff.dbFilesUniq) {
                if (duplicatesMap.containsKey(f2)) continue;
                List duplicates = diff.dbFilesUniq.stream().filter(f2::equals).sorted(Comparator.comparing(sfw -> sfw == null ? "" : StringUtils.trimToEmpty((String)sfw.getPath()))).collect(Collectors.toList());
                assert (duplicates.size() > 0);
                if (duplicates.size() <= 1) continue;
                duplicatesMap.put(f2, duplicates);
            }
            String sep = LINE_SEPARATOR + "  ";
            duplicatesMap.forEach((file, duplicateList) -> {
                Set mediaItems = itemsPerFile.getOrDefault(file, Collections.emptySet());
                if (mediaItems.size() == duplicateList.size()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("File \"" + file.getName() + "\" mapped to multiple videos: " + mediaItems.stream().map(Object::toString).collect(Collectors.joining(", "))));
                    }
                } else {
                    logger.warn((Object)duplicateList.stream().map(IFileWrapper::getName).collect(Collectors.joining(sep, "Duplicates: " + sep, "")));
                }
            });
        }
        if (diff.fsFilesUniq.size() != inFs.size()) {
            logger.warn((Object)(prefix + "FILES IN FILESYSTEM MIGHT CONTAIN DUPLICATES."));
            for (int i = 0; i < inFs.size(); ++i) {
                IFileWrapper f3 = inFs.get(i);
                if (inFs.lastIndexOf(f3) == i) continue;
                logger.warn((Object)("Duplicate in filesystem: " + f3.getPath()));
            }
        }
        if (diff.inDbButNotInFs.size() > 0) {
            logger.info((Object)(prefix + diff.inDbButNotInFs.size() + " FILES WERE NOT FOUND IN FILESYSTEM:"));
            diff.inDbButNotInFs.forEach(f -> logger.warn((Object)("Referenced file not found: " + f)));
        }
        if (diff.inFsButNotInDb.size() > 0) {
            logger.warn((Object)(prefix + diff.inFsButNotInDb.size() + " FILES WERE NOT FUND IN DATABASE:"));
            diff.inFsButNotInDb.forEach(f -> logger.warn((Object)("File is not in database: " + f)));
        }
        return diff;
    }

    static void displaySearchResults(List<String> searchExpressions, Map<String, List<Movie>> foundMovies) {
        StringBuilder b = new StringBuilder();
        int longestExprLen = searchExpressions.stream().mapToInt(String::length).max().orElseThrow(() -> new IllegalArgumentException("empty? " + searchExpressions));
        for (String wt : searchExpressions) {
            List<Movie> hits = foundMovies.get(wt);
            b.setLength(0);
            if (hits == null) {
                b.append("    ");
            } else {
                assert (hits.size() > 0);
                b.append(":-) ");
            }
            b.append("Expression ");
            b.append(StringUtils.rightPad((String)("'" + wt + "'"), (int)(longestExprLen + 2)));
            if (hits == null) {
                b.append(" did not match any movie. Searched for: ").append(App.toWords(wt));
            } else {
                assert (hits.size() > 0);
                b.append(" matched ").append(hits.size()).append(" movies. ").append(hits);
            }
            logger.info((Object)b);
        }
    }

    static class Diff {
        Set<IFileWrapper> dbFilesUniq;
        List<IFileWrapper> dbFilesFlat;
        Set<IFileWrapper> fsFilesUniq;
        Set<IFileWrapper> inDbButNotInFs = new LinkedHashSet<IFileWrapper>();
        Set<IFileWrapper> inFsButNotInDb = new LinkedHashSet<IFileWrapper>();

        Diff() {
        }
    }
}

