/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.kodi;

import com.myapp.kodi.PrintUtil;
import com.myapp.kodi.common.domain.Movie;
import com.myapp.kodi.common.domain.TvShow;
import com.myapp.kodi.common.domain.Video;
import com.myapp.kodi.common.service.KodiService;
import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.kodi.common.util.TaggingStrategy;
import com.myapp.kodi.common.util.sftp.SftpConnectionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class App {
    private static final Logger logger = Logger.getLogger(App.class);
    private final KodiService kodi;
    private final TaggingStrategy taggingStrategy;
    private List<Movie> allMoviesCached;
    private List<TvShow> allTvShowsCached;
    public static final Pattern BLACKLISTED_EXTS = Pattern.compile("(?ix).* \\. (jpe?g|idx|sub|ac3|srt|nfo|txt|sfv|ssa|log|sh) $");
    public static final Pattern BLACKLISTED_DIRS = Pattern.compile("(?ix).* /EXTRAS/ .*");
    @Autowired(required=false)
    private SftpConnectionManager sftpConnectionManager;

    private App(KodiService kodi, TaggingStrategy taggingsy) {
        this.kodi = kodi;
        this.taggingStrategy = taggingsy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        int result;
        App app = App.createApplication();
        long startTime = System.currentTimeMillis();
        try {
            result = App.invokeBusinessLogic(args, app);
        }
        finally {
            if (app.sftpConnectionManager != null) {
                app.sftpConnectionManager.closeAllConnections();
            }
        }
        long finishTime = System.currentTimeMillis();
        long executionTime = finishTime - startTime;
        logger.debug((Object)("executionTime = " + executionTime));
        System.exit(result);
    }

    public static int invokeBusinessLogic(String[] args, App app) throws ParseException {
        Options opts = new Options();
        opts.addOption("ls", "list-roots", false, "List media file roots");
        opts.addOption("shows", "display-show-status", false, "List shows that are unclean");
        opts.addOption("movies", "display-movie-status", false, "List movies that are unclean");
        opts.addOption("tagmovies", "display-movie-status", false, "Creates movie tags");
        opts.addOption("moviesearch", "search-movies", true, "Search through movies");
        opts.addOption("testmoviesearch", "search-movies", false, "Test the search through movies");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(opts, args);
        if (cmd.hasOption("ls")) {
            app.printMediaFileRoots();
            return 0;
        }
        if (cmd.hasOption("shows")) {
            app.invokeShowBusinessLogic();
            return 0;
        }
        if (cmd.hasOption("movies")) {
            app.invokeMovieBusinessLogic();
            return 0;
        }
        if (cmd.hasOption("tagmovies")) {
            app.createMovieTags();
            return 0;
        }
        if (cmd.hasOption("moviesearch")) {
            String searchString = cmd.getOptionValue("moviesearch");
            List<String> pattern = Collections.singletonList(searchString);
            Map<String, List<Movie>> result = app.searchVariousMovies(pattern);
            System.out.println("Found " + result.size() + " matches for " + searchString + ":");
            result.forEach((searchStr, list) -> list.forEach(m -> System.out.println(m.getTitle() + " - " + m.getSmbFilesToString())));
            return 0;
        }
        if (cmd.hasOption("testmoviesearch")) {
            app.searchVariousMovies();
            return 0;
        }
        new HelpFormatter().printHelp("Kodi-Helper", opts);
        return 1;
    }

    public static App createApplication() {
        logger.debug((Object)"init spring context...");
        ClassPathXmlApplicationContext c = new ClassPathXmlApplicationContext("applicationContext.xml");
        logger.debug((Object)"spring context initialized.");
        logger.debug((Object)"create application...");
        App app = new App((KodiService)c.getBean(KodiService.class), (TaggingStrategy)c.getBean(TaggingStrategy.class));
        c.getAutowireCapableBeanFactory().autowireBean((Object)app);
        logger.debug((Object)"application created.");
        return app;
    }

    private void invokeShowBusinessLogic() {
        logger.debug((Object)"Fetching all episodes' files from database...");
        LinkedHashMap<Video, List<IFileWrapper>> db = this.getAllTvShowFilesInDatabaseAsMap();
        logger.debug((Object)"Fetching all episodes' files from filesystem...");
        List<IFileWrapper> inFileSystem = this.getAllTvShowVideoFilesInFileSystem();
        PrintUtil.showDifferences("episodes", db, inFileSystem);
    }

    private void invokeMovieBusinessLogic() {
        logger.debug((Object)"fetching all movies' files from database...");
        LinkedHashMap<Video, List<IFileWrapper>> inDb = this.getAllMovieFilesInDatabaseAsMap();
        logger.debug((Object)"fetching all movies' files from filesystem...");
        List<IFileWrapper> inFs = this.getAllMovieVideoFilesInFileSystem();
        PrintUtil.showDifferences("movies", inDb, inFs);
    }

    public void createMovieTags() {
        logger.debug((Object)"Creating all movie tags...");
        Map<String, Predicate<Movie>> tagRules = this.taggingStrategy.getMovieTagRules();
        List<Movie> allMovies = this.loadAllMoviesCached();
        LinkedHashMap<String, Set<Movie>> moviesByTagName = new LinkedHashMap<String, Set<Movie>>();
        for (Movie m : allMovies) {
            tagRules.forEach((tagName, predicate) -> {
                if (predicate.test(m)) {
                    moviesByTagName.computeIfAbsent((String)tagName, foo -> new LinkedHashSet()).add(m);
                }
            });
        }
        logger.info((Object)("Linking " + moviesByTagName.values().stream().flatMap(Collection::stream).distinct().count() + " movies to " + moviesByTagName.size() + " tags. TagsLinks to be created: " + moviesByTagName.values().stream().mapToInt(Set::size).sum()));
        this.kodi.tagMovies(moviesByTagName);
    }

    private List<Movie> loadAllMoviesCached() {
        if (this.allMoviesCached == null) {
            this.allMoviesCached = this.kodi.loadAllMovies();
        }
        return this.allMoviesCached;
    }

    private List<TvShow> loadAllTvShowsCached() {
        if (this.allTvShowsCached == null) {
            this.allTvShowsCached = this.kodi.loadAllTvShows();
        }
        return this.allTvShowsCached;
    }

    public TvShow findByTvShowName(String name) {
        return this.kodi.findByTvShowName(name);
    }

    public void printMediaFileRoots() {
        List<IFileWrapper> roots = this.kodi.getAllShares();
        logger.info((Object)("MediaFile Roots: (" + roots.size() + ")"));
        roots.forEach(path -> logger.info((Object)("shared directory found: " + path)));
    }

    private void searchVariousMovies() {
        List<String> searchExpressions = Arrays.asList("Batman vs superman 2016", "What if (2014)", "In bruges", "Tim and erics million dollar movie", "13 assassins", "Mad max", "Fargo", "Nightcrawler", "Aloys", "Green room", "Blue ruin", "Swiss army man", "Lost in translation", "Dr strange", "History of Violence. ", "Mothman", "The Secret in Their Eyes", "Sicario", "Casino", "Trash", "District 8", "Miracle_at_St._Anna", "Conspiracy", "Suicide squad", "Bad lieutnant", "Gruber geht", "Was hat uns bloss so ruiniert", "Hotel rock n roll", "B\u00f6sterreich", "Schlawiner", "Hinterholz 8", "Braunschlag", "The Necessary Death of Charlie Countryman");
        Map<String, List<Movie>> foundMovies = this.searchVariousMovies(searchExpressions);
        PrintUtil.displaySearchResults(searchExpressions, foundMovies);
    }

    public Map<String, List<Movie>> searchVariousMovies(List<String> searchExpressions) {
        if (new HashSet<String>(searchExpressions).size() != searchExpressions.size()) {
            throw new RuntimeException("Duplicate search expressions: " + searchExpressions);
        }
        logger.info((Object)("Searching for " + searchExpressions.size() + " search terms in movies..."));
        Map wantedWords = searchExpressions.stream().collect(Collectors.toMap(o -> o, App::toWords, (a, b) -> a, LinkedHashMap::new));
        LinkedHashMap<String, List<Movie>> result = new LinkedHashMap<String, List<Movie>>();
        ((Stream)this.loadAllMoviesCached().stream().parallel()).forEach(m -> {
            List<String> movieWords = App.toWords(StringUtils.trimToEmpty((String)m.getTitle()) + " " + StringUtils.trimToEmpty((String)m.getOriginalTitle()));
            wantedWords.forEach((term, words) -> {
                Set matches = words.stream().filter(movieWords::contains).collect(Collectors.toSet());
                if (matches.size() == words.size()) {
                    logger.debug((Object)(m + " matched search term " + term));
                    List list = (List)result.get(term);
                    if (list == null) {
                        Map map = result;
                        synchronized (map) {
                            list = result.computeIfAbsent((String)term, foo -> new ArrayList());
                        }
                    }
                    list.add(m);
                }
            });
        });
        logger.debug((Object)("Search ended. Hits: " + result.size() + ", movies found: " + result.values().stream().flatMap(Collection::stream).distinct().count()));
        return result;
    }

    static List<String> toWords(String term) {
        return Stream.of(term.toLowerCase().replaceAll("(19|20)[0-9][0-9]", " ").replaceAll("[^a-z0-9]", " ").replaceAll("\\b(and|a|st|vs|the|in|of|der|das|at)\\b", " ").replaceAll("\\s+", " ").trim().split("\\s+")).distinct().sorted().collect(Collectors.toList());
    }

    public List<IFileWrapper> getAllTvShowVideoFilesInFileSystem() {
        return this.getAllVideoFilesInFileSystem(this.kodi.getTvShowShares());
    }

    private LinkedHashMap<Video, List<IFileWrapper>> getAllTvShowFilesInDatabaseAsMap() {
        List<Video> tvShows = this.loadAllTvShowsCached().stream().flatMap(s -> s.getEpisodes().stream()).map(e -> e).collect(Collectors.toList());
        return App.getVideoFilesAsMap(tvShows);
    }

    public Stream<IFileWrapper> filterBlackList(Stream<IFileWrapper> inputStream) {
        return inputStream.filter(f -> {
            String urlAsString = f.getURLAsString();
            return !BLACKLISTED_EXTS.matcher(urlAsString).matches() && !BLACKLISTED_DIRS.matcher(urlAsString).matches();
        });
    }

    public List<IFileWrapper> getFiles(IFileWrapper parentDir) {
        Stream<IFileWrapper> blackListFiltered = this.filterBlackList(parentDir.streamChildrenRecursively().filter(IFileWrapper::isFile));
        return blackListFiltered.sorted().collect(Collectors.toList());
    }

    private List<IFileWrapper> getAllVideoFilesInFileSystem(List<IFileWrapper> roots) {
        Stream<IFileWrapper> blackListFiltered = this.filterBlackList(roots.parallelStream().flatMap(IFileWrapper::streamChildrenRecursively).filter(IFileWrapper::isFile));
        return blackListFiltered.sorted().collect(Collectors.toList());
    }

    static LinkedHashMap<Video, List<IFileWrapper>> getVideoFilesAsMap(List<Video> videos) {
        return videos.stream().collect(Collectors.toMap(m -> m, Video::getSmbFiles, (a, b) -> {
            LinkedHashSet uniq = new LinkedHashSet(a.size() + b.size());
            uniq.addAll(a);
            uniq.addAll(b);
            return new ArrayList(uniq);
        }, LinkedHashMap::new));
    }

    public List<IFileWrapper> getAllMovieVideoFilesInFileSystem() {
        return this.getAllVideoFilesInFileSystem(this.kodi.getMovieShares());
    }

    private LinkedHashMap<Video, List<IFileWrapper>> getAllMovieFilesInDatabaseAsMap() {
        List<Video> movies = this.loadAllMoviesCached().stream().map(e -> e).collect(Collectors.toList());
        return App.getVideoFilesAsMap(movies);
    }

    public SftpConnectionManager getSftpConnectionManager() {
        return this.sftpConnectionManager;
    }

    public void setSftpConnectionManager(SftpConnectionManager sftpConnectionManager) {
        this.sftpConnectionManager = sftpConnectionManager;
    }
}

