package com.myapp.kodi.impl.kodi_MyVideos99.repo;

import com.myapp.kodi.impl.kodi_MyVideos99.entities.TvShowEntity;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * repository for tvshows
 *
 * Created by andre on 3/20/17.
 */
@Repository
public interface TvShowRepository
        extends CrudRepository<TvShowEntity, Integer>,
                JpaSpecificationExecutor<TvShowEntity> {

    @Query("select distinct s from TvShowEntity s " +
            "left outer join fetch s.episodes e " +
            "left outer join fetch e.file ef " +
            "left outer join fetch ef.path efp " +
            "left outer join fetch efp.parent"
    )
    Iterable<TvShowEntity> findAll();


    @Query("select s from TvShowEntity s " +
            "left outer join fetch s.episodes e " +
            "left outer join fetch e.file ef " +
            "left outer join fetch ef.path efp " +
            "left outer join fetch efp.parent " +
            "where s.title = :name"
    )
    TvShowEntity findByTvShowName(@Param("name") String name);
}
