package com.myapp.kodi.impl.kodi_MyVideos99.repo;

import com.myapp.kodi.impl.kodi_MyVideos99.entities.MovieEntity;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

/**
 * repository for movies
 *
 * Created by andre on 7/19/15.
 */
@Repository
public interface MovieRepository
        extends CrudRepository<MovieEntity, Integer>, JpaSpecificationExecutor<MovieEntity> {

    @Query("select distinct m from MovieEntity m " +
            "left outer join fetch m.file f " +
            "left outer join fetch f.path p " +
            "left outer join fetch p.parent " +
            "left outer join fetch m.tags")
    Iterable<MovieEntity> findAll();

}
