package com.myapp.kodi.impl.kodi_MyVideos99.entities;

import org.hibernate.annotations.Where;
import org.hibernate.annotations.WhereJoinTable;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

/**
 * A TvShow database entity
 *
 * Created by andre on 3/16/17.
 */
@Entity
@Table(name = "tvshow")
@Where(clause = "idShow > 0")
public class TvShowEntity implements Serializable {

    @Id
    @Column(name = "idShow", nullable = false)
    private int idShow;

    @Basic
    @Column(name = "c00")
    private String title;

    @Basic
    @Column(name = "c01")
    private String plot;

    @Basic
    @Column(name = "c05")
    private String firstAired;

    @OneToMany(mappedBy = "tvShow")
    private List<EpisodeEntity> episodes;

    @ManyToMany
    @JoinTable(
            name = "tag_link",
            joinColumns = {@JoinColumn(name = "media_id", referencedColumnName = "idShow")},
            inverseJoinColumns = {@JoinColumn(name = "tag_id", referencedColumnName = "tag_id")}
    )
    @WhereJoinTable(clause = "media_type='tvshow'")
    private List<TagEntity> tags;

    public int getIdShow() {
        return idShow;
    }

    public void setIdShow(int idShow) {
        this.idShow = idShow;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPlot() {
        return plot;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    public String getFirstAired() {
        return firstAired;
    }

    public void setFirstAired(String firstAired) {
        this.firstAired = firstAired;
    }

    public List<EpisodeEntity> getEpisodes() {
        return episodes;
    }

    public void setEpisodes(List<EpisodeEntity> episodeEntities) {
        this.episodes = episodeEntities;
    }

    public List<TagEntity> getTags() {
        return tags;
    }

    public void setTags(List<TagEntity> tagLinkEntities) {
        this.tags = tagLinkEntities;
    }
}
