package com.myapp.kodi.impl.kodi_MyVideos99.entities;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.Serializable;

/**
 * the key object for a taglink entity
 *
 * Created by andre on 3/26/17.
 */
public class TagLinkKey implements Serializable {

    private String mediaType;
    private int tagId;
    private int mediaId;

    public String getMediaType() {
        return mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public int getMediaId() {
        return mediaId;
    }

    public void setMediaId(int mediaId) {
        this.mediaId = mediaId;
    }

    public int getTagId() {
        return tagId;
    }

    public void setTagId(int tagId) {
        this.tagId = tagId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        TagLinkKey that = (TagLinkKey) o;

        return new EqualsBuilder()
                .append(tagId, that.tagId)
                .append(mediaId, that.mediaId)
                .append(mediaType, that.mediaType)
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
                .append(mediaType)
                .append(tagId)
                .append(mediaId)
                .toHashCode();
    }
}
