package com.myapp.kodi.impl.kodi_MyVideos99.entities;

import javax.persistence.*;
import java.io.Serializable;

/**
 * A TagLink database entity.
 * Note: this entity is not referenced by the other entities,
 * it acts only as a mapping table for
 * {@link com.myapp.kodi.impl.kodi_MyVideos99.repo.TagLinkRepository}
 * to insert taglinks.
 *
 * Created by andre on 3/16/17.
 */
@Entity
@IdClass(TagLinkKey.class)
@Table(name = "tag_link")
public class TagLinkEntity implements Serializable {

    @Id
    @Column(name = "media_type", nullable = false)
    private String mediaType;

    @Id
    @Column(name = "tag_id", nullable = false)
    private int tagId;

    @Id
    @Column(name = "media_id", nullable = false)
    private int mediaId;

    public String getMediaType() {
        return mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public int getMediaId() {
        return mediaId;
    }

    public void setMediaId(int media) {
        this.mediaId = media;
    }

    public int getTagId() {
        return tagId;
    }

    public void setTagId(int tagId) {
        this.tagId = tagId;
    }
}
