package com.myapp.kodi.impl.kodi_MyVideos99.entities;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

/**
 * A path database entity
 *
 * Created by andre on 3/16/17.
 */
@Entity
@Table(name = "path")
public class PathEntity implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "idPath", nullable = false)
    private int idPath;

    @Basic
    @Column(name = "strPath")
    private String strPath;

    @Basic
    @Column(name = "strContent")
    private String strContent;

    @Basic
    @Column(name = "dateAdded")
    private String dateAdded;

    @OneToMany(mappedBy = "path")
    private List<FileEntity> files;

    @ManyToOne
    @JoinColumn(name = "idParentPath", referencedColumnName = "idPath")
    private PathEntity parent;


    public int getIdPath() {
        return idPath;
    }

    public void setIdPath(int idPath) {
        this.idPath = idPath;
    }

    public String getStrPath() {
        return strPath;
    }

    public void setStrPath(String strPath) {
        this.strPath = strPath;
    }

    public String getDateAdded() {
        return dateAdded;
    }

    public void setDateAdded(String dateAdded) {
        this.dateAdded = dateAdded;
    }

    public List<FileEntity> getFiles() {
        return files;
    }

    public void setFiles(List<FileEntity> fileEntities) {
        this.files = fileEntities;
    }

    public PathEntity getParent() {
        return parent;
    }

    public void setParent(PathEntity parent) {
        this.parent = parent;
    }

    public String getStrContent() {
        return strContent;
    }

    public void setStrContent(String strContent) {
        this.strContent = strContent;
    }

}
