package com.myapp.kodi.impl.kodi_MyVideos99.entities;

import org.hibernate.annotations.WhereJoinTable;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

/**
 * A movie database entity
 *
 * Created by andre on 3/16/17.
 */
//@SuppressWarnings("unused") // getters and setters
@Entity
@Table(name = "movie")
public class MovieEntity implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "idMovie", nullable = false)
    private int idMovie;

    @Basic
    @Column(name = "c00")
    private String title;

    @Basic
    @Column(name = "c16", columnDefinition = "text")
    private String originalTitle;

    @Basic
    @Column(name = "c01")
    private String plot;

    @Basic
    @Column(name = "c04")
    private String ratingVotes;

    @Basic
    @Column(name = "c05")
    private String rating;

    @Basic
    @Column(name = "c07")
    private String releaseYear;

    @Basic
    @Column(name = "c09")
    private String imdbId;

    @Basic
    @Column(name = "c11")
    private String runtimeSeconds;

    @Basic
    @Column(name = "c21")
    private String country;

    @OneToOne
    @JoinColumn(name = "idFile", referencedColumnName = "idFile")
    private FileEntity file;

    @ManyToMany
    @JoinTable(
        name = "tag_link",
        joinColumns = {@JoinColumn(name = "media_id", referencedColumnName = "idMovie")},
        inverseJoinColumns = {@JoinColumn(name = "tag_id", referencedColumnName = "tag_id")}
    )
    @WhereJoinTable(clause = "media_type='movie'")
    private List<TagEntity> tags;

    public int getIdMovie() {
        return idMovie;
    }

    public void setIdMovie(int idMovie) {
        this.idMovie = idMovie;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPlot() {
        return plot;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    public String getRatingVotes() {
        return ratingVotes;
    }

    public void setRatingVotes(String ratingVotes) {
        this.ratingVotes = ratingVotes;
    }

    public String getRating() {
        return rating;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public String getReleaseYear() {
        return releaseYear;
    }

    public void setReleaseYear(String releaseYear) {
        this.releaseYear = releaseYear;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public String getRuntimeSeconds() {
        return runtimeSeconds;
    }

    public void setRuntimeSeconds(String runtimeSeconds) {
        this.runtimeSeconds = runtimeSeconds;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public FileEntity getFile() {
        return file;
    }

    public void setFile(FileEntity fileEntity) {
        this.file = fileEntity;
    }

    public List<TagEntity> getTags() {
        return tags;
    }

    public void setTags(List<TagEntity> tagLinkEntities) {
        this.tags = tagLinkEntities;
    }

    public String getOriginalTitle() {
        return originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = originalTitle;
    }
}
