package com.myapp.kodi.impl.kodi_MyVideos99.entities;

import javax.persistence.*;
import java.io.Serializable;

/**
 *
 * An episode database entity
 *
 * Created by andre on 3/16/17.
 */
@SuppressWarnings("unused") // getters and setters
@Entity
@Table(name = "episode")
public class EpisodeEntity implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "idEpisode", nullable = false)
    private int idEpisode;

    @Basic
    @Column(name = "c00")
    private String title;

    @Basic
    @Column(name = "c01")
    private String plot;

    @Basic
    @Column(name = "c02")
    private String ratingVotes;

    @Basic
    @Column(name = "c03")
    private String rating;

    @Basic
    @Column(name = "c05")
    private String airDate;

    @Basic
    @Column(name = "c08")
    private String watched;

    @Basic
    @Column(name = "c09")
    private String runtimeMinutes;

    @Basic
    @Column(name = "c12", length = 24)
    private String season;

    @Basic
    @Column(name = "c13", length = 24)
    private String episode;

    @ManyToOne
    @JoinColumn(name = "idShow", referencedColumnName = "idShow")
    private TvShowEntity tvShow;

    @OneToOne
    @JoinColumn(name = "idFile", referencedColumnName = "idFile")
    private FileEntity file;


    public int getIdEpisode() {
        return idEpisode;
    }

    public void setIdEpisode(int idEpisode) {
        this.idEpisode = idEpisode;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPlot() {
        return plot;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    public String getRatingVotes() {
        return ratingVotes;
    }

    public void setRatingVotes(String ratingVotes) {
        this.ratingVotes = ratingVotes;
    }

    public String getRating() {
        return rating;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public String getAirDate() {
        return airDate;
    }

    public void setAirDate(String airDate) {
        this.airDate = airDate;
    }

    public String getWatched() {
        return watched;
    }

    public void setWatched(String watched) {
        this.watched = watched;
    }

    public String getRuntimeMinutes() {
        return runtimeMinutes;
    }

    public void setRuntimeMinutes(String runtimeMinutes) {
        this.runtimeMinutes = runtimeMinutes;
    }

    public String getSeason() {
        return season;
    }

    public void setSeason(String season) {
        this.season = season;
    }

    public String getEpisode() {
        return episode;
    }

    public void setEpisode(String episode) {
        this.episode = episode;
    }

    public TvShowEntity getTvShow() {
        return tvShow;
    }

    public void setTvShow(TvShowEntity tvShow) {
        this.tvShow = tvShow;
    }

    public FileEntity getFile() {
        return file;
    }

    public void setFile(FileEntity fileEntity) {
        this.file = fileEntity;
    }

}
