package com.myapp.kodi.impl.andre;

import com.myapp.kodi.common.domain.Movie;
import com.myapp.kodi.common.domain.TvShow;
import com.myapp.kodi.common.util.PathBasedRule;
import com.myapp.kodi.common.util.TaggingStrategy;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

import static com.myapp.kodi.common.util.PathBasedRule.Rule.*;

/**
 * Created by andre on 4/5/17.
 */
public class TaggingStrategyImpl implements TaggingStrategy {

    @Override
    public Map<String, Predicate<Movie>> getMovieTagRules() {
        Map<String, Predicate<Movie>> tagRules = new LinkedHashMap<>();

        tagRules.put("Movies DE", new PathBasedRule()
                .add(requireAnyOf, "/GERMAN/", "/MULTILANGUAGE/"));

        tagRules.put("Movies EN", new PathBasedRule()
                .add(requireAnyOf, "/ENGLISH/", "/MULTILANGUAGE/"));

        tagRules.put("Movies KIDS", new PathBasedRule()
                .add(requireAnyOf, "/KIDS/"));

        tagRules.put("Movies ADULTS", new PathBasedRule()
                .add(mustNotContainAnyOf, "/KIDS/"));

        tagRules.put("Movies ADULTS EN", new PathBasedRule()
                .add(requireAnyOf, "/ENGLISH/", "/MULTILANGUAGE/")
                .add(mustNotContainAnyOf, "/KIDS/"));

        tagRules.put("Movies ADULTS DE", new PathBasedRule()
                .add(requireAnyOf, "/GERMAN/", "/MULTILANGUAGE/")
                .add(mustNotContainAllOf, "/KIDS/"));

        tagRules.put("Movies KIDS DE", new PathBasedRule()
                .add(requireAnyOf, "/GERMAN/", "/MULTILANGUAGE/")
                .add(requireAllOf, "/KIDS/"));

        tagRules.put("Movies KIDS EN", new PathBasedRule()
                .add(requireAnyOf, "/ENGLISH/", "/MULTILANGUAGE/")
                .add(requireAllOf, "/KIDS/"));

        tagRules.put("Austria related", new PathBasedRule()
                .add(requireAnyOf, "/GERMAN/", "/MULTILANGUAGE/")
                .add(requireAllOf, "/austria-related-movies/"));
        return tagRules;
    }

    @Override
    public Map<String, Predicate<TvShow>> getTvShowTagRules() {
        throw new UnsupportedOperationException("not yet implemented.");
    }
}
