package com.myapp.kodi.impl.andre;

import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.kodi.common.util.smb.SmbToLocalFileMapper;
import com.myapp.kodi.common.service.DomainObjectMapper;
import org.apache.log4j.Logger;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * implementation for andres smbFileMapping
 *
 * Created by andre on 3/26/17.
 */
public class AndresSmbToLocalFileMapper implements SmbToLocalFileMapper {

    private static final Logger logger = Logger.getLogger(AndresSmbToLocalFileMapper.class);


    private static final Map<String, String> SMB_TO_LOCAL;
    private static final Map<String, String> LOCAL_TO_SMB;
    static {
        String[][] mappings = {
            {"smb://NAIROBI/av-content/_movies/", "/media/filestore/av-content/movies/"},
            {"smb://NAIROBI/av-content/_series/", "/media/filestore/av-content/series/"}
        };

        Map<String, String> stl = new HashMap<>();
        Map<String, String> lts = new HashMap<>();

        for (String[] mapping : mappings) {
            boolean stlMappingOk = null == stl.put(mapping[0], mapping[1]);
            boolean ltsMappingOk = null == lts.put(mapping[1], mapping[0]);
            if (!stlMappingOk || !ltsMappingOk) {
                throw new RuntimeException("duplicate mapping: " + Arrays.toString(mapping));
            }
        }

        SMB_TO_LOCAL = Collections.unmodifiableMap(stl);
        LOCAL_TO_SMB = Collections.unmodifiableMap(lts);
    }

    private final DomainObjectMapper mapper = new DomainObjectMapper();

    @Override
    public File toLocalFile(IFileWrapper networkFile) {
        String path = networkFile.getPath();

        for (Map.Entry<String, String> entry : SMB_TO_LOCAL.entrySet()) {
            if (path.startsWith(entry.getKey())) {
                path = path.replace(entry.getKey(), entry.getValue());
                break;
            }
        }

        if (networkFile.getPath().equals(path)) {
            logger.warn("could not translate to file system: " + networkFile);
            return null;
        }

        return new File(path);
    }

    public IFileWrapper toSmbFile(File localFile) {
        String path = localFile.getAbsolutePath();

        for (Map.Entry<String, String> entry : LOCAL_TO_SMB.entrySet()) {
            if (path.startsWith(entry.getKey())) {
                path = path.replace(entry.getKey(), entry.getValue());
                break;
            }
        }

        if (localFile.getPath().equals(path)) {
            logger.warn("could not translate to file system: " + localFile);
            return null;
        }

        return mapper.createFileWrapper(path);
    }
}
