package com.myapp.kodi.impl.andre;

import com.myapp.kodi.common.domain.Video;
import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.kodi.common.util.LanguageDeterminator;

import java.util.EnumSet;
import java.util.Optional;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * implementation for how to recognize languages in andres collection.
 *
 * Created by andre on 3/20/17.
 */
public class AndresPathLanguageDeterminator implements LanguageDeterminator {

    @Override
    public EnumSet<Language> getLanguages(Video mediaItem) {
        EnumSet<Language> languages = EnumSet.noneOf(Language.class);
        Optional<IFileWrapper> optional = mediaItem.getFirstSmbFile();

        if (optional.isPresent()) {
            String path = optional.get().getPath();

            if (isNotBlank(path)) {
                if (path.contains("/ENGLISH/")) {
                    languages.add(Language.ENGLISH);
                }
                if (path.contains("/GERMAN/")) {
                    languages.add(Language.GERMAN);
                }
                if (path.contains("/MULTILANGUAGE/")) {
                    languages.add(Language.ENGLISH);
                    languages.add(Language.GERMAN);
                }
            }
        }

        return languages;
    }
}
