package com.myapp.kodi.common.util.smb;

import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.util.file.RecursiveTreeIterator.TreeNode;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;

import java.net.MalformedURLException;
import java.util.List;
import java.util.stream.Collectors;

/**
 * wraps an smbfile into a recursively iterable node
 *
 * Created by andre on 8/4/15.
 */
public class SmbFileNode implements TreeNode<SmbFileWrapper>, Comparable<SmbFileNode> {


    private String url;
    private NtlmPasswordAuthentication auth;

    public SmbFileNode(SmbFileWrapper smbFileWrapper) {
        this.url = smbFileWrapper.getURL().toString();
        this.auth = smbFileWrapper.getAuthentication();
    }

    public SmbFileNode(String url, NtlmPasswordAuthentication auth) {
        this.url = url;
        this.auth = auth;
    }


    @Override
    public List<TreeNode<SmbFileWrapper>> getChildren() {
        SmbFileWrapper value = getValue();
        List<IFileWrapper> smbFiles = value.listFiles();

        if (smbFiles == null) {
            return null;
        }

        return smbFiles.stream()
                .map(f -> new SmbFileNode(f.getURL().toString(), auth))
                .sorted()
                .collect(Collectors.toList());
    }

    @Override
    public SmbFileWrapper getValue() {
        try {
            return new SmbFileWrapper(new SmbFile(url, auth));
        } catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(SmbFileNode o) {
        return getValue().compareTo(o.getValue());
    }
}
