package com.myapp.kodi.common.util.sftp;

import com.myapp.kodi.common.util.IFileWrapper;
import com.myapp.util.file.RecursiveTreeIterator.TreeNode;

import java.util.List;
import java.util.stream.Collectors;

/**
 * wraps an smbfile into a recursively iterable node
 *
 * Created by andre on 8/4/15.
 */
public class SftpFileNode implements TreeNode<SftpFileWrapper>, Comparable<SftpFileNode> {

    private SftpFileWrapper wrapper;

    public SftpFileNode(SftpFileWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public List<TreeNode<SftpFileWrapper>> getChildren() {
        if (wrapper.isFile()) {
            return null;
        }

        SftpFileWrapper value = getValue();
        List<IFileWrapper> smbFiles = value.listFiles();

        if (smbFiles == null || smbFiles.isEmpty()) {
            return null;
        }

        return smbFiles.stream()
                .filter(f -> !f.getName().equals(".")
                        && !f.getName().equals("..")
                        && !f.getPath().equals(wrapper.getPath()))
                .map(f -> {
                    SftpFileWrapper w;
                    if (f.isFile() && (f instanceof SftpFileWrapper)) {
                        // ls() not needed in this case
                        w = (SftpFileWrapper) f;
                    } else {
                        w = new SftpFileWrapper(wrapper.getSftpConnectionManager(), f.getURLAsString());
                    }
                    return new SftpFileNode(w);
                })
                .sorted()
                .collect(Collectors.toList());
    }

    @Override
    public SftpFileWrapper getValue() {
        return wrapper;
    }

    @Override
    public int compareTo(SftpFileNode o) {
        return getValue().compareTo(o.getValue());
    }
}
