package com.myapp.kodi.common.util;

import com.myapp.kodi.common.domain.Video;
import org.springframework.stereotype.Component;

import java.util.EnumSet;

import static com.myapp.kodi.common.util.LanguageDeterminator.Language.*;

/**
 * decides which languages a {@link Video} has
 *
 * Created by andre on 3/20/17.
 */
@Component
public interface LanguageDeterminator {

    enum Language { GERMAN, ENGLISH }

    EnumSet<Language> getLanguages(Video videoFile);

    default boolean isEnglish(Video video) {
        return getLanguages(video).contains(ENGLISH);
    }

    default boolean isGerman(Video video) {
        return getLanguages(video).contains(GERMAN);
    }

    default boolean isMultilingual(Video video) {
        EnumSet<Language> languages = getLanguages(video);
        return languages.contains(GERMAN) && languages.contains(ENGLISH);
    }

}
