package com.myapp.kodi.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.stream.Stream;

public interface IFileWrapper extends Comparable<IFileWrapper> {

    String getName();

    String getPath();

    String getParent();

    boolean isDirectory();

    boolean isFile();

    List<IFileWrapper> listFiles();

    long getLength();

    InputStream getInputStream() throws IOException;

    URL getURL();
    String getURLAsString();

    IFileWrapper getParentWrapped();

    Stream<IFileWrapper> streamChildrenRecursively();

    default int compareTo(IFileWrapper o) {
        boolean thisIsDir = this.isDirectory();
        boolean oIsDir = o.isDirectory();

        if (thisIsDir == oIsDir) {
            return String.valueOf(getURL()).compareTo(String.valueOf(o.getURL()));
        }

        return thisIsDir ? -1 : 1;
    }
}
