package com.myapp.kodi.common.service;

import com.myapp.kodi.common.domain.Movie;
import com.myapp.kodi.common.domain.Tag;
import com.myapp.kodi.common.domain.TvShow;
import com.myapp.kodi.common.util.IFileWrapper;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * interface for kodi database used by {@link com.myapp.kodi.App}
 * <p>
 * Created by andre on 3/25/17.
 */
@Service
public interface KodiService {


    int UNPARSEABLE_INT_VALUE = -333;


    // related to movie


    List<IFileWrapper> getMovieShares();

    TvShow findByTvShowName(String name);

    List<Movie> loadAllMovies();

    void tagMovies(Map<String, Set<Movie>> tagDefinitions);

    default void tagMovie(Movie m, String tag) {
        tagMovies(Collections.singletonMap(tag, Collections.singleton(m)));
    }



    // related to tv shows


    List<TvShow> loadAllTvShows();

    void tag(TvShow m, String tag);

    List<IFileWrapper> getTvShowShares();


    // tags


    List<Tag> loadAllTags();


    // utils/convenience


    default List<IFileWrapper> getAllShares() {
        List<IFileWrapper> result = new ArrayList<>();
        result.addAll(getMovieShares());
        result.addAll(getTvShowShares());
        return result;
    }

}
