package com.myapp.kodi.common.domain;

import com.myapp.kodi.common.util.IFileWrapper;

import java.util.List;
import java.util.Optional;

/**
 * a video consists of files.
 *
 * Created by andre on 3/25/17.
 */
public interface Video extends Titled {

    List<IFileWrapper> getSmbFiles();

    default Optional<IFileWrapper> getFirstSmbFile() {
        return getSmbFiles().stream().findFirst();
    }

    default String getSmbFilesToString() {
        final StringBuilder sb = new StringBuilder();
        List<IFileWrapper> smbFiles = getSmbFiles();

        if (smbFiles == null || smbFiles.isEmpty()) {
            sb.append(smbFiles);

        } else if (smbFiles.size() > 1){
            sb.append(smbFiles.size() + " files");

        } else {
            sb.append(smbFiles.get(0).getName());
        }

        return sb.toString();
    }

}
