package com.myapp.kodi.common.domain;

import java.util.*;

/**
 * a tvshow represents a series of episodes
 *
 * Created by andre on 3/25/17.
 */
public class TvShow extends AbstractDomainObject implements Titled {

    private String title;
    private String plot;
    private int firsAired;
    private SortedSet<Episode> episodes = new TreeSet<>();
    private List<Tag> tags;

    public TvShow(int id) {
        super(id);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return title;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    @Override
    public String getPlot() {
        return plot;
    }

    public void setFirsAired(int firsAired) {
        this.firsAired = firsAired;
    }

    public int getFirsAired() {
        return firsAired;
    }

    public void addEpisode(Episode episode) {
        episode.setTvShow(this);
    }

    public void removeEpisode(Episode episode) {
        episode.setTvShow(null);
    }

    public List<Episode> getEpisodes() {
        return new ArrayList<>(episodes);
    }

    void internalAddEpisode(Episode episode) {
        episodes.add(episode);
    }

    void internalRemoveEpisode(Episode episode) {
        episodes.remove(episode);
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<Tag> getTags() {
        return tags;
    }

    @Override
    public String toString() {
        return "Tvs " + getIdToString() + " " +
                "'" +  getTitleToString() + "' " +
                "episodes: " + (episodes == null || episodes.isEmpty() ? 0 : episodes.size());
    }
}
