package com.myapp.kodi.common.domain;

import com.myapp.kodi.common.util.IFileWrapper;

import java.util.List;
import java.util.Objects;

import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * a movie
 *
 * Created by andre on 3/25/17.
 */
public class Movie extends AbstractDomainObject implements Video, Comparable<Movie> {

    private String title;
    private String originalTitle;
    private String plot;
    private int releaseYear;
    private String imdbId;
    private List<IFileWrapper> smbFiles;
    private int runtimeSeconds;
    private List<Tag> tags;

    public Movie(int id) {
        super(id);
    }

    @Override
    public List<IFileWrapper> getSmbFiles() {
        return smbFiles;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return title;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    @Override
    public String getPlot() {
        return plot;
    }

    public void setReleaseYear(int releaseYear) {
        this.releaseYear = releaseYear;
    }

    public int getReleaseYear() {
        return releaseYear;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setSmbFiles(List<IFileWrapper> smbFiles) {
        this.smbFiles = smbFiles;
    }

    public void setRuntimeSeconds(int runtimeSeconds) {
        this.runtimeSeconds = runtimeSeconds;
    }

    public int getRuntimeSeconds() {
        return runtimeSeconds;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<Tag> getTags() {
        return tags;
    }

    @Override
    public int compareTo(Movie o) {
        if (this.equals(o)) {
            return 0;
        }

        int cmp = Objects.compare(title, o.title, String.CASE_INSENSITIVE_ORDER);
        if (cmp != 0) {
            return cmp;
        }

        cmp = Integer.compare(releaseYear, o.releaseYear);
        if (cmp != 0) {
            return cmp;
        }

        return Integer.compare(getId(), o.getId());
    }

    public boolean hasTag(String tagName) {
        if (isBlank(tagName)) {
            throw new RuntimeException();
        }
        return tags.stream().anyMatch(t -> t.getName().equals(tagName));
    }

    @Override
    public String toString() {
        return getTitle() + " (" + getReleaseYear() + ") " +
                "id: " + getId() + ", files: " + getSmbFilesToString();
    }

    public String getOriginalTitle() {
        return originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = originalTitle;
    }
}
