/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster.x01;

import com.myapp.games.dartmaster.AbstractGame;
import com.myapp.games.dartmaster.Move;
import com.myapp.games.dartmaster.Player;
import com.myapp.games.dartmaster.util.Dart;
import com.myapp.games.dartmaster.x01.X01Game;
import com.myapp.games.dartmaster.x01.X01Score;
import java.util.List;

class X01MoveAction
extends AbstractGame.AbstractMoveAction {
    X01MoveAction() {
    }

    @Override
    protected void actImpl(AbstractGame game, Move move) {
        X01Game x = (X01Game)game;
        Player player = move.getPlayer();
        X01Score xScore = x.getX01Score(player);
        List<Dart> dartList = move.getDartList();
        for (Dart dart : dartList) {
            int currentScore = xScore.getScore();
            if (x.isDoubleIn() && currentScore == x.getInitialScore() && dart.getFactor() != 2) continue;
            int dartScore = dart.getValue();
            int projectedScore = currentScore - dartScore;
            if (x.isDoubleOut()) {
                if (projectedScore == 1 || projectedScore == 0 && dart.getFactor() != 2) {
                    break;
                }
            } else if (projectedScore == 0) {
                xScore.setScore(0);
                break;
            }
            if (projectedScore < 0) break;
            xScore.setScore(projectedScore);
        }
    }

    @Override
    protected void undoImpl(AbstractGame game, Move move) {
        X01Game x = (X01Game)game;
        Player player = move.getPlayer();
        X01Score xScore = x.getX01Score(player);
        List<Dart> dartList = move.getDartList();
        for (Dart dart : dartList) {
            int scoreAfterMove = xScore.getScore();
            int dartScore = dart.getValue();
            xScore.setScore(scoreAfterMove + dartScore);
        }
    }
}

