/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster.x01;

import com.myapp.games.dartmaster.AbstractGame;
import com.myapp.games.dartmaster.Player;
import com.myapp.games.dartmaster.x01.X01MoveAction;
import com.myapp.games.dartmaster.x01.X01Score;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;

@Entity
public class X01Game
extends AbstractGame {
    private static final long serialVersionUID = -7980735037938566758L;
    private boolean doubleIn = false;
    private boolean doubleOut = false;
    private int initialScore = 501;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @OrderColumn(name="list_index")
    private final List<X01Score> scoreBoardList = new ArrayList<X01Score>();

    @Override
    protected AbstractGame.AbstractMoveAction newMoveAction() {
        return new X01MoveAction();
    }

    @Override
    protected void initImpl() {
        this.scoreBoardList.clear();
        this.getPlayers().stream().map(X01Score::new).peek(x -> x.setScore(this.initialScore)).forEach(this.scoreBoardList::add);
    }

    @Override
    public boolean isGameOverImpl() {
        return this.scoreBoardList.stream().anyMatch(x -> x.getScore() == 0);
    }

    @Override
    public Map<Integer, List<Player>> getCurrentPlacementsImpl() {
        LinkedHashMap<Integer, List<Player>> result = new LinkedHashMap<Integer, List<Player>>();
        HashSet<X01Score> remainingScores = new HashSet<X01Score>(this.scoreBoardList);
        int placement = 1;
        while (remainingScores.size() > 0) {
            int lowestScore = remainingScores.stream().mapToInt(X01Score::getScore).min().orElseThrow(EmptyStackException::new);
            List<X01Score> lowestScores = remainingScores.stream().filter(x -> x.getScore() == lowestScore).collect(Collectors.toList());
            lowestScores.forEach(remainingScores::remove);
            result.put(placement, lowestScores.stream().map(X01Score::getPlayer).collect(Collectors.toList()));
            ++placement;
        }
        return result;
    }

    public List<X01Score> getScoreBoard() {
        return Collections.unmodifiableList(this.scoreBoardList);
    }

    public boolean isDoubleIn() {
        return this.doubleIn;
    }

    public void setDoubleIn(boolean doubleIn) {
        this.assertNotRunning();
        this.doubleIn = doubleIn;
    }

    public boolean isDoubleOut() {
        return this.doubleOut;
    }

    public void setDoubleOut(boolean doubleOut) {
        this.assertNotRunning();
        this.doubleOut = doubleOut;
    }

    public int getInitialScore() {
        return this.initialScore;
    }

    public void setInitialScore(int initialScore) {
        this.assertNotRunning();
        if (initialScore < 1 || initialScore > 5000) {
            throw new IllegalArgumentException("score must be between 1 and 5000");
        }
        this.initialScore = initialScore;
    }

    public int getScore(Player player) {
        X01Score x01Score = this.getX01Score(player);
        return x01Score.getScore();
    }

    public X01Score getX01Score(Player player) {
        List<Player> players = this.getPlayers();
        int index = players.indexOf(player);
        return this.scoreBoardList.get(index);
    }
}

