/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster.util;

import java.io.Serializable;
import java.util.Arrays;

public enum Field implements Serializable
{
    BULL(25, "Bull"),
    F20(20, "20"),
    F19(19, "19"),
    F18(18, "18"),
    F17(17, "17"),
    F16(16, "16"),
    F15(15, "15"),
    F14(14, "14"),
    F13(13, "13"),
    F12(12, "12"),
    F11(11, "11"),
    F10(10, "10"),
    F9(9, "9"),
    F8(8, "8"),
    F7(7, "7"),
    F6(6, "6"),
    F5(5, "5"),
    F4(4, "4"),
    F3(3, "3"),
    F2(2, "2"),
    F1(1, "1");

    static Field[] allByOrdinal;
    private final int score;
    private final int doubleScore;
    private final int tripleScore;
    private final String toString;

    private Field(int score, String toString) {
        this.score = score;
        this.doubleScore = score * 2;
        this.tripleScore = score * 3;
        this.toString = toString;
    }

    public int getSingleHitScore() {
        return this.score;
    }

    public int getScore(int factor) {
        switch (factor) {
            case 1: {
                return this.score;
            }
            case 2: {
                return this.doubleScore;
            }
            case 3: {
                if (this == BULL) {
                    throw new IllegalArgumentException("triple bull");
                }
                return this.tripleScore;
            }
        }
        throw new IllegalArgumentException("Field: " + this.name() + ", factor: " + factor);
    }

    public static Field byName(String name) {
        return Arrays.stream(Field.values()).filter(f -> f.toString.equals(name)).findAny().orElseThrow(() -> new RuntimeException("No Field has name " + name));
    }

    public static Field byOrdinal(int ordinal) {
        return allByOrdinal[ordinal];
    }

    public String toString() {
        return this.toString;
    }

    static {
        allByOrdinal = new Field[]{BULL, F20, F19, F18, F17, F16, F15, F14, F13, F12, F11, F10, F9, F8, F7, F6, F5, F4, F3, F2, F1};
    }
}

