/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster.util;

import com.myapp.games.dartmaster.Events;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class EventListeners
implements Events.Listener {
    private static final Logger logger = Logger.getLogger(Events.class);
    private static final Events.Listener loggingListener = (event, args) -> {
        if (!logger.isInfoEnabled()) {
            return;
        }
        String message = Events.eventToString(event, args);
        logger.info((Object)message);
    };
    private static final long serialVersionUID = 6322377451098790784L;
    private final Set<Events.Listener> listeners = new LinkedHashSet<Events.Listener>();

    public void add(Events.Listener listener) {
        this.listeners.add(listener);
    }

    public void remove(Events.Listener o) {
        this.listeners.remove(o);
    }

    public void clear() {
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(String event, Serializable ... args) {
        EventListeners eventListeners = this;
        synchronized (eventListeners) {
            loggingListener.onEvent(event, args);
            this.listeners.forEach(l -> l.onEvent(event, args));
        }
    }
}

