/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster.util;

import com.myapp.games.dartmaster.util.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class Dart
implements Serializable {
    private static final long serialVersionUID = -3764746861036083928L;
    private final Field field;
    private final int factor;

    public Dart(Field field, int factor) {
        this.field = field;
        this.factor = factor;
    }

    public Dart(Field field) {
        this(field, 1);
    }

    public Field getField() {
        return this.field;
    }

    public int getFactor() {
        return this.factor;
    }

    public int getValue() {
        return this.field.getScore(this.factor);
    }

    public String toString() {
        if (this.field == Field.BULL && this.factor == 2) {
            return "B.Eye";
        }
        switch (this.factor) {
            case 1: {
                return this.field.toString();
            }
            case 2: {
                return "D" + this.field;
            }
            case 3: {
                return "T" + this.field;
            }
        }
        throw new IllegalStateException("Field: " + this.field + ", Factor: " + this.factor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dart dart = (Dart)o;
        return new EqualsBuilder().append(this.factor, dart.factor).append((Object)this.field, (Object)dart.field).isEquals();
    }

    public static Dart fromByteValue(byte byteValue) {
        int corrected = Byte.toUnsignedInt(byteValue);
        int fieldOrdinalCode = corrected >>> 3;
        int factorCode = corrected & 3;
        Field field = Field.byOrdinal(fieldOrdinalCode);
        return new Dart(field, factorCode + 1);
    }

    public static byte asByteValue(Dart dart) {
        int ordinalEncoded = dart.field.ordinal();
        if (ordinalEncoded > 31) {
            throw new IllegalStateException("cannot decode more than 32 ordinals using 5 bytes: " + dart);
        }
        int ordinalCode = ordinalEncoded << 3;
        int factorCode = dart.factor - 1;
        int code = factorCode | ordinalCode;
        return (byte)code;
    }

    private static String getToBinaryString(int i) {
        return StringUtils.leftPad((String)Integer.toString(i), (int)6) + ": 0X" + Integer.toBinaryString(i);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.field).append(this.factor).toHashCode();
    }

    public static String serializeDart(Dart d) {
        if (d.getField() == Field.BULL) {
            switch (d.getFactor()) {
                case 1: {
                    return "Bull";
                }
                case 2: {
                    return "Eye";
                }
            }
            throw new IllegalArgumentException("Bull x " + d.getFactor() + " ???");
        }
        String fieldStr = d.getField().name().replaceFirst("^F", "");
        switch (d.getFactor()) {
            case 1: {
                return fieldStr;
            }
            case 2: {
                return "D" + fieldStr;
            }
            case 3: {
                return "T" + fieldStr;
            }
        }
        throw new IllegalArgumentException("Factor " + d.getFactor() + " ???");
    }

    public static Dart parse(String input) {
        return Dart.parseList(input, 1).get(0);
    }

    public static List<Dart> parseList(String input) {
        return Dart.parseList(input, Integer.MAX_VALUE);
    }

    private static List<Dart> parseList(String input, int limit) {
        ArrayList<Dart> result = new ArrayList<Dart>();
        Matcher matcher = Pattern.compile("(?x) \\s* (t|d|[1-9]x|) \\s* ([1-9][0-9]?|b|bull|be|e|bullseye|eye) \\s* (,|$) ").matcher(input.toLowerCase());
        for (int i = 0; i < limit && matcher.find(); ++i) {
            String factorStr = matcher.group(1);
            String fieldStr = matcher.group(2);
            int factor = 1;
            Field field = Field.BULL;
            switch (fieldStr) {
                case "e": 
                case "be": 
                case "eye": 
                case "bullseye": {
                    if (StringUtils.isNotBlank((CharSequence)factorStr) && !factorStr.equals("2x") && !factorStr.equals("d")) {
                        throw new IllegalArgumentException("Factor '" + factorStr + "' not allowed for '" + fieldStr + "'");
                    }
                    factor = 2;
                    break;
                }
                case "b": 
                case "bull": {
                    if (!StringUtils.isNotBlank((CharSequence)factorStr) || factorStr.equals("1x")) break;
                    throw new IllegalArgumentException("Factor not allowed for '" + fieldStr + "'");
                }
                default: {
                    switch (factorStr) {
                        case "": 
                        case "1x": {
                            break;
                        }
                        case "d": 
                        case "2x": {
                            factor = 2;
                            break;
                        }
                        case "t": 
                        case "3x": {
                            factor = 3;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unrecognized factor '" + factorStr + "'");
                        }
                    }
                    field = Field.valueOf("F" + fieldStr);
                }
            }
            Dart dart = new Dart(field, factor);
            result.add(dart);
        }
        return result;
    }

    public static String serializeDartList(List<Dart> darts) {
        return darts.stream().map(Dart::serializeDart).collect(Collectors.joining(", "));
    }
}

