/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster.experimental;

import com.myapp.games.dartmaster.experimental.Driver;
import com.myapp.games.dartmaster.experimental.Reporter;
import java.time.DayOfWeek;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;

@Entity
public class Race {
    @Id
    @SequenceGenerator(name="Race_id_SeqGen", sequenceName="Race_Sequence", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="Race_id_SeqGen")
    private Long id;
    @ManyToOne(cascade={CascadeType.ALL})
    private Driver winner;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @OrderColumn(name="list_index")
    private List<Driver> drivers;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<Reporter> reporters;
    @ElementCollection
    @Enumerated(value=EnumType.STRING)
    private Set<DayOfWeek> racingDays = new TreeSet<DayOfWeek>(Comparator.comparingInt(Enum::ordinal));
    @ElementCollection
    @MapKeyEnumerated(value=EnumType.STRING)
    private Map<DayOfWeek, Integer> lapsPerDay = new TreeMap<DayOfWeek, Integer>();
    private String title;

    public Race() {
    }

    public Race(Long id, List<Driver> drivers, Set<Reporter> reporters, String title) {
        this.id = id;
        this.drivers = drivers;
        this.reporters = reporters;
        this.title = title;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public List<Driver> getParticipants() {
        return this.drivers;
    }

    public void setParticipants(List<Driver> rankings) {
        this.drivers = rankings;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Set<Reporter> getReporters() {
        return this.reporters;
    }

    public void setReporters(Set<Reporter> reporters) {
        this.reporters = reporters;
    }

    public Set<DayOfWeek> getRacingDays() {
        return this.racingDays;
    }

    public void setRacingDays(Set<DayOfWeek> racingDays) {
        this.racingDays = racingDays;
    }

    public Driver getWinner() {
        return this.winner;
    }

    public void setWinner(Driver winner) {
        this.winner = winner;
    }

    public List<Driver> getDrivers() {
        return this.drivers;
    }

    public void setDrivers(List<Driver> drivers) {
        this.drivers = drivers;
    }

    public Map<DayOfWeek, Integer> getLapsPerDay() {
        return this.lapsPerDay;
    }

    public void setLapsPerDay(Map<DayOfWeek, Integer> lapsPerDay) {
        this.lapsPerDay = lapsPerDay;
    }
}

