/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster.cricket;

import com.myapp.games.dartmaster.Player;
import com.myapp.games.dartmaster.util.Field;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.CascadeType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.SequenceGenerator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
public final class CricketScore
implements Serializable {
    private static final long serialVersionUID = -9196649969371979279L;
    @Id
    @SequenceGenerator(name="CricketScore_id_SeqGen", sequenceName="CricketScore_Sequence", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CricketScore_id_SeqGen")
    private long id;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Player player;
    @ElementCollection
    @MapKeyEnumerated(value=EnumType.STRING)
    private final Map<Field, Integer> hits = new TreeMap<Field, Integer>();
    private int points = 0;

    public CricketScore() {
    }

    CricketScore(Player p) {
        this.player = p;
    }

    public String getPlayerName() {
        return this.player.getName();
    }

    public int getPoints() {
        return this.points;
    }

    public int getHitCount(Field field) {
        Integer counter = this.hits.get(field);
        return counter == null ? 0 : counter;
    }

    public Map<Field, Integer> _getHitCountersCopy() {
        return new HashMap<Field, Integer>(this.hits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CricketScore score = (CricketScore)o;
        return new EqualsBuilder().append(this.getPoints(), score.getPoints()).append((Object)this.getPlayer(), (Object)score.getPlayer()).append(this.getHits(), score.getHits()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getPlayer()).append(this.getPoints()).append(this.getHits()).toHashCode();
    }

    void setPoints(int points) {
        this.points = points;
    }

    public Player getPlayer() {
        return this.player;
    }

    void setHit(Field key, int hitCount) {
        if (hitCount < 1) {
            this.hits.remove(key);
            return;
        }
        this.hits.put(key, hitCount);
    }

    Map<Field, Integer> getHits() {
        return this.hits;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    void setHits(Map<Field, Integer> hits) {
        this.hits.clear();
        this.hits.putAll(hits);
    }
}

