/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster.cricket;

import com.myapp.games.dartmaster.AbstractGame;
import com.myapp.games.dartmaster.Move;
import com.myapp.games.dartmaster.Player;
import com.myapp.games.dartmaster.cricket.Cricket;
import com.myapp.games.dartmaster.cricket.CricketScore;
import com.myapp.games.dartmaster.util.Dart;
import com.myapp.games.dartmaster.util.Field;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class CricketMoveAction
extends AbstractGame.AbstractMoveAction {
    CricketMoveAction() {
    }

    @Override
    protected void actImpl(AbstractGame game, Move move) {
        Cricket c = (Cricket)game;
        Player movingPlayer = move.getPlayer();
        List<Dart> wellAimed = move.getDartList().stream().filter(t -> c.getAimingAt().contains(t.getField())).collect(Collectors.toList());
        CricketScore score = c.getCricketScore(movingPlayer);
        wellAimed.forEach(t -> {
            int overshot;
            Field field = t.getField();
            Map<Field, Integer> hits = score.getHits();
            Integer valueOriginal = hits.computeIfAbsent(field, x -> 0);
            int hitsBeforeThrow = valueOriginal;
            int hitsOfThrow = t.getFactor();
            int hitCountTarget = c.getHitCountTarget();
            int hitsNeededToClose = Math.max(0, hitCountTarget - hitsBeforeThrow);
            int hitsAfterThrow = valueOriginal + hitsOfThrow;
            score.setHit(field, hitsAfterThrow);
            if (hitsBeforeThrow < hitCountTarget && hitsAfterThrow >= hitCountTarget) {
                c.getListeners().onEvent("cricketFieldClosed", new Serializable[]{movingPlayer.getName(), field});
            }
            if ((overshot = hitsOfThrow - hitsNeededToClose) <= 0) {
                return;
            }
            int punishment = field.getSingleHitScore() * overshot;
            this.punish(c, movingPlayer, field, punishment);
        });
    }

    @Override
    protected void undoImpl(AbstractGame game, Move move) {
        Player movingPlayer = move.getPlayer();
        Cricket c = (Cricket)game;
        Set<Dart> wellAimed = move.getDartList().stream().filter(t -> c.getAimingAt().contains(t.getField())).collect(Collectors.toSet());
        CricketScore score = c.getCricketScore(movingPlayer);
        wellAimed.forEach(t -> {
            Field field = t.getField();
            int counter = score.getHitCount(field);
            int hitsOfThrow = move.getDartList().stream().filter(d -> d.equals(t)).mapToInt(Dart::getFactor).sum();
            int hitsBeforeThrow = counter - hitsOfThrow;
            int hitsNeededToClose = Math.max(0, c.getHitCountTarget() - hitsBeforeThrow);
            score.setHit(field, counter -= hitsOfThrow);
            int overshot = hitsOfThrow - hitsNeededToClose;
            if (overshot <= 0) {
                return;
            }
            int undoPunishment = -1 * field.getSingleHitScore() * overshot;
            this.punish(c, movingPlayer, field, undoPunishment);
        });
    }

    private void punish(Cricket c, Player movingPlayer, Field field, int punishment) {
        List<CricketScore> scoresToPunish = c.getPlayersToPunish(movingPlayer, field);
        if (scoresToPunish.isEmpty()) {
            return;
        }
        scoresToPunish.forEach(p -> p.setPoints(p.getPoints() + punishment));
        c.getListeners().onEvent("cricketScoring", new Serializable[]{Cricket.scoreNames(scoresToPunish), Integer.valueOf(punishment), movingPlayer.getName()});
    }
}

