/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster.cricket;

import com.myapp.games.dartmaster.AbstractGame;
import com.myapp.games.dartmaster.Defaults;
import com.myapp.games.dartmaster.Player;
import com.myapp.games.dartmaster.cricket.CricketMoveAction;
import com.myapp.games.dartmaster.cricket.CricketScore;
import com.myapp.games.dartmaster.util.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.log4j.Logger;

@Entity
public class Cricket
extends AbstractGame {
    private static final long serialVersionUID = 4465578643583714296L;
    private static final Logger scoreLog = Logger.getLogger((String)(Cricket.class.getName() + ".ScoreCalculation"));
    @ElementCollection(fetch=FetchType.EAGER)
    @Enumerated(value=EnumType.STRING)
    private final Set<Field> aimingAt = new TreeSet<Field>(Defaults.DEFAULT_FIELDS);
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @OrderColumn(name="list_index")
    private final List<CricketScore> scoreBoardList = new ArrayList<CricketScore>();
    @Basic(optional=false)
    private boolean cutThroat = true;
    @Basic(optional=false)
    private int hitCountTarget = 3;

    @Override
    protected void initImpl() {
        this.scoreBoardList.clear();
        this.getPlayers().forEach(p -> this.scoreBoardList.add(new CricketScore((Player)p)));
    }

    public CricketScore getCricketScore(Player player) {
        List<Player> players = this.getPlayers();
        int index = players.indexOf(player);
        return this.scoreBoardList.get(index);
    }

    List<CricketScore> getPlayersToPunish(Player movingPlayer, Field field) {
        List<Player> players = this.getPlayers();
        Stream<CricketScore> toPunish = players.stream().filter(x -> !x.equals(movingPlayer)).map(player -> this.scoreBoardList.get(players.indexOf(player)));
        if (this.isCutThroat()) {
            toPunish = toPunish.filter(s -> this.isFieldOpen((CricketScore)s, field));
        }
        return toPunish.collect(Collectors.toList());
    }

    @Override
    public AbstractGame.AbstractMoveAction newMoveAction() {
        return new CricketMoveAction();
    }

    public void setAimingAt(Collection<Field> aimingAt) {
        this.assertNotRunning();
        this.aimingAt.clear();
        this.aimingAt.addAll(aimingAt);
    }

    public Set<Field> getAimingAt() {
        return Collections.unmodifiableSet(this.aimingAt);
    }

    public void setCutThroat(boolean cutThroat) {
        this.assertNotRunning();
        this.cutThroat = cutThroat;
    }

    public boolean isCutThroat() {
        return this.cutThroat;
    }

    @Override
    public boolean isGameOverImpl() {
        List allClosedPlayers = this.scoreBoardList.stream().filter(s -> this.getClosedFields((CricketScore)s).containsAll(this.aimingAt)).collect(Collectors.toList());
        if (allClosedPlayers.isEmpty()) {
            return false;
        }
        int bestScore = this.scoreBoardList.stream().mapToInt(CricketScore::getPoints).min().orElseThrow(EmptyStackException::new);
        for (CricketScore player : allClosedPlayers) {
            if (player.getPoints() != bestScore) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Integer, List<Player>> getCurrentPlacementsImpl() {
        scoreLog.info((Object)"******* calculation of placements start *********");
        LinkedHashMap<Integer, List<Player>> result = new LinkedHashMap<Integer, List<Player>>();
        MutableInt counter = new MutableInt(1);
        LinkedHashSet<CricketScore> yetUndetermined = new LinkedHashSet<CricketScore>(this.scoreBoardList);
        while (!yetUndetermined.isEmpty()) {
            Integer rank = counter.getValue();
            if (yetUndetermined.size() == 1) {
                Player best = ((CricketScore)yetUndetermined.iterator().next()).getPlayer();
                if (scoreLog.isInfoEnabled()) {
                    scoreLog.info((Object)("* Assign last player " + best.getName() + " to rank " + rank));
                }
                result.put(rank, Collections.singletonList(best));
                break;
            }
            if (scoreLog.isInfoEnabled()) {
                scoreLog.info((Object)("* Searching rank " + rank + " out of: " + Cricket.scoreNames(yetUndetermined)));
            }
            List<Player> scores = this.collectNextBestScore(yetUndetermined, rank);
            result.put(rank, scores);
            yetUndetermined.removeIf(s -> scores.contains(s.getPlayer()));
            counter.increment();
            if (!scoreLog.isInfoEnabled()) continue;
            scoreLog.info((Object)("* Added " + Cricket.playerNames(scores) + " to rank " + rank + " ..."));
        }
        scoreLog.info((Object)"******* calculation of placements finished *********");
        return result;
    }

    private List<Player> collectNextBestScore(Set<CricketScore> scores, int rank4debug) {
        if (scores.size() < 2) {
            throw new IllegalStateException("makes no sense with less than two elements");
        }
        List<CricketScore> mostClosedFields = Cricket.getBestScores(s -> this.getClosedFields((CricketScore)s).size(), scores);
        if (mostClosedFields.size() == 1) {
            CricketScore best = mostClosedFields.get(0);
            if (scoreLog.isInfoEnabled()) {
                scoreLog.info((Object)String.format("* Player %s gets on rank %d because having most fields closed.", best.getPlayerName(), rank4debug));
            }
            return Collections.singletonList(best.getPlayer());
        }
        List<CricketScore> highestHitValueSum = Cricket.getBestScores(this.bySumOfHitValues(), mostClosedFields);
        if (highestHitValueSum.size() == 1) {
            CricketScore best = highestHitValueSum.get(0);
            if (scoreLog.isInfoEnabled()) {
                scoreLog.info((Object)String.format("* Player %s gets on rank %d because of the highest sum of hit values.", best.getPlayerName(), rank4debug));
            }
            return Collections.singletonList(best.getPlayer());
        }
        List<CricketScore> lowestScore = Cricket.getBestScores(score -> -1 * score.getPoints(), highestHitValueSum);
        if (lowestScore.size() == 1) {
            CricketScore best = lowestScore.get(0);
            if (scoreLog.isInfoEnabled()) {
                scoreLog.info((Object)String.format("* Player %s gets on rank %d because of having the best score.", best.getPlayerName(), rank4debug));
            }
            return Collections.singletonList(best.getPlayer());
        }
        if (scoreLog.isInfoEnabled()) {
            scoreLog.info((Object)String.format("* Player(s) %s are equal by rank %d with %d score points.", Cricket.scoreNames(lowestScore), rank4debug, lowestScore.get(0).getPoints()));
        }
        return lowestScore.stream().map(CricketScore::getPlayer).collect(Collectors.toList());
    }

    private ToIntFunction<CricketScore> bySumOfHitValues() {
        return score -> score.getHits().entrySet().stream().mapToInt(e -> {
            Field key = (Field)e.getKey();
            int timesHit = Math.min((Integer)e.getValue(), this.getHitCountTarget());
            return key.getSingleHitScore() * timesHit;
        }).sum();
    }

    private static List<CricketScore> getBestScores(ToIntFunction<CricketScore> countStrategy, Collection<CricketScore> remainingPlayers) {
        int highestValue = remainingPlayers.stream().mapToInt(countStrategy).max().orElseThrow(EmptyStackException::new);
        List<CricketScore> bestScores = remainingPlayers.stream().filter(s -> countStrategy.applyAsInt((CricketScore)s) == highestValue).collect(Collectors.toList());
        if (bestScores.isEmpty()) {
            throw new IllegalStateException("score must have at least one entry");
        }
        return bestScores;
    }

    public void setHitCountTarget(int hitCountTarget) {
        this.assertNotRunning();
        if (hitCountTarget < 1 || hitCountTarget > 6) {
            throw new IllegalArgumentException("Hit count must be between 1 and 6");
        }
        this.hitCountTarget = hitCountTarget;
    }

    public int getHitCountTarget() {
        return this.hitCountTarget;
    }

    public static String scoreNames(Collection<CricketScore> players) {
        return players.stream().map(CricketScore::getPlayerName).collect(Collectors.joining(", "));
    }

    public List<CricketScore> getScoreBoardList() {
        return this.scoreBoardList;
    }

    public void setScoreBoardList(List<CricketScore> scoreBoardList) {
        this.scoreBoardList.clear();
        this.scoreBoardList.addAll(scoreBoardList);
    }

    public List<Field> getClosedFields(Player player) {
        CricketScore score = this.getCricketScore(player);
        return this.getClosedFields(score);
    }

    public List<Field> getClosedFields(CricketScore cricketScore) {
        Map<Field, Integer> hits = cricketScore.getHits();
        return hits.entrySet().stream().filter(e -> (Integer)e.getValue() >= this.hitCountTarget).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public boolean isFieldOpen(CricketScore cricketScore, Field field) {
        Map<Field, Integer> hits = cricketScore.getHits();
        Integer counter = hits.get(field);
        return counter == null || counter < this.hitCountTarget;
    }
}

