/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster;

import com.myapp.games.dartmaster.Move;
import com.myapp.games.dartmaster.util.Dart;
import com.myapp.games.dartmaster.util.Field;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.SequenceGenerator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
public class StatisticsCollector
implements Serializable {
    private static final long serialVersionUID = -1391653547421132540L;
    @Id
    @SequenceGenerator(name="StatisticsCollector_id_SeqGen", sequenceName="StatisticsCollector_Sequence", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="StatisticsCollector_id_SeqGen")
    private int id;
    private String bestMoveString = null;
    @ElementCollection
    @MapKeyEnumerated(value=EnumType.STRING)
    private final Map<Field, Integer> fieldHits = new TreeMap<Field, Integer>();
    private int movesMade = 0;
    private int dartsHit = 0;
    private int nothingHit = 0;
    private int somethingHit = 0;
    private int noHitSeriesLongest = 0;
    private int noHitSeriesCurrent = 0;
    private int hitSeriesLongest = 0;
    private int hitSeriesCurrent = 0;

    void collectStatistics(Move move) {
        int hitValues = move.countHitValues();
        if (StringUtils.isNotBlank((CharSequence)this.bestMoveString)) {
            Move bestMoveSoFar = Move.parse(this.bestMoveString);
            int bestMoveSoFarHitValue = bestMoveSoFar.countHitValues();
            if (hitValues > bestMoveSoFarHitValue) {
                this.bestMoveString = Move.serialize(move);
            }
        } else {
            this.bestMoveString = Move.serialize(move);
        }
        ++this.movesMade;
        List<Dart> dartList = move.getDartList();
        this.dartsHit += dartList.size();
        if (dartList.isEmpty()) {
            ++this.nothingHit;
            ++this.noHitSeriesCurrent;
            if (this.hitSeriesCurrent > this.hitSeriesLongest) {
                this.hitSeriesLongest = this.hitSeriesCurrent;
            }
            this.hitSeriesCurrent = 0;
        } else {
            ++this.somethingHit;
            ++this.hitSeriesCurrent;
            if (this.noHitSeriesCurrent > this.noHitSeriesLongest) {
                this.noHitSeriesLongest = this.noHitSeriesCurrent;
            }
            this.noHitSeriesCurrent = 0;
        }
        dartList.forEach(d -> this.fieldHits.merge(d.getField(), d.getFactor(), Integer::sum));
    }

    public int getLongesHitSeries() {
        return Math.max(this.hitSeriesLongest, this.hitSeriesCurrent);
    }

    public int getLongestNoHitSeries() {
        return Math.max(this.noHitSeriesLongest, this.noHitSeriesCurrent);
    }

    public int getBestMove() {
        return this.bestMoveString == null ? 0 : Move.parse(this.bestMoveString).countHitValues();
    }

    public Map<Field, Integer> getFieldHits() {
        return Collections.unmodifiableMap(this.fieldHits);
    }

    public int getMovesMade() {
        return this.movesMade;
    }

    public int getDartsHit() {
        return this.dartsHit;
    }

    public int getNothingHit() {
        return this.nothingHit;
    }

    public int getSomethingHit() {
        return this.somethingHit;
    }

    public String getBestMoveString() {
        return this.bestMoveString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticsCollector that = (StatisticsCollector)o;
        return new EqualsBuilder().append(this.movesMade, that.movesMade).append(this.dartsHit, that.dartsHit).append(this.nothingHit, that.nothingHit).append(this.somethingHit, that.somethingHit).append(this.noHitSeriesLongest, that.noHitSeriesLongest).append(this.noHitSeriesCurrent, that.noHitSeriesCurrent).append(this.hitSeriesLongest, that.hitSeriesLongest).append(this.hitSeriesCurrent, that.hitSeriesCurrent).append((Object)this.bestMoveString, (Object)that.bestMoveString).append(this.fieldHits, that.fieldHits).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.bestMoveString).append(this.fieldHits).append(this.movesMade).append(this.dartsHit).append(this.nothingHit).append(this.somethingHit).append(this.noHitSeriesLongest).append(this.noHitSeriesCurrent).append(this.hitSeriesLongest).append(this.hitSeriesCurrent).toHashCode();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

