/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster;

import com.myapp.games.dartmaster.Move;
import com.myapp.games.dartmaster.StatisticsCollector;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
public final class Player
implements Serializable {
    private static final long serialVersionUID = -5181797067151135672L;
    @Id
    @SequenceGenerator(name="Player_id_SeqGen", sequenceName="Player_Sequence", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="Player_id_SeqGen")
    private int id = -1;
    @Basic(optional=false)
    @Column(unique=true, updatable=false)
    private String name;
    @Basic(optional=false)
    private int sessionScore;
    @OneToOne(optional=false, cascade={CascadeType.ALL})
    @JoinColumn(updatable=false, unique=true)
    private StatisticsCollector stats;

    public Player() {
    }

    public Player(String name) {
        this.name = name;
        this.stats = new StatisticsCollector();
    }

    void collectStatistics(Move move) {
        this.stats.collectStatistics(move);
    }

    public StatisticsCollector getStats() {
        return this.stats;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSessionScore() {
        return this.sessionScore;
    }

    void incrementSessionScore(int points) {
        this.sessionScore += points;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Player player = (Player)o;
        return new EqualsBuilder().append((Object)this.name, (Object)player.name).append(this.id, player.id).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append(this.id).toHashCode();
    }

    public String toString() {
        return this.name + '(' + this.sessionScore + ')';
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setStats(StatisticsCollector stats) {
        this.stats = stats;
    }
}

