/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster;

import com.myapp.games.dartmaster.Player;
import com.myapp.games.dartmaster.util.Dart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Move {
    private final List<Dart> dartList;
    private Player player;
    private int round;

    public Move(Collection<Dart> darts) {
        this.dartList = Collections.unmodifiableList(new ArrayList<Dart>(darts));
    }

    public Move(Dart ... darts) {
        this(Arrays.asList(darts));
    }

    public int countHitValues() {
        return this.dartList.stream().mapToInt(Dart::getValue).sum();
    }

    public List<Dart> getDartList() {
        return this.dartList;
    }

    void setPlayer(Player player) {
        this.player = player;
    }

    public int getRound() {
        return this.round;
    }

    void setRound(int round) {
        this.round = round;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String toString() {
        return this.dartList.toString();
    }

    public static Move parse(String input) {
        List<Dart> darts = Dart.parseList(input);
        return new Move(darts);
    }

    public static String serialize(Move move) {
        return Dart.serializeDartList(move.getDartList());
    }
}

