/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster;

import java.io.Serializable;

public class Events {
    public static final String EVENT_GAME_STARTED = "gameStarted";
    public static final String EVENT_MOVE_SUBMITTED = "moveSubmitted";
    public static final String EVENT_ROUND_FINISHED = "roundFinished";
    public static final String EVENT_ROUND_STARTED = "roundStarted";
    public static final String EVENT_GAME_OVER = "gameOver";
    public static final String EVENT_GAME_SESSION_POINTS_ADDED = "gameSessionPointsAdded";
    public static final String EVENT_GAME_UNDO = "gameUndo";
    public static final String EVENT_CRICKET_FIELD_CLOSED = "cricketFieldClosed";
    public static final String EVENT_CRICKET_SCORING = "cricketScoring";

    public static String eventToString(String event, Serializable ... args) {
        switch (event) {
            case "gameStarted": {
                return String.format("New game started with %s.", args);
            }
            case "gameOver": {
                return String.format("Game over. %s won.", args);
            }
            case "gameSessionPointsAdded": {
                int points = ((Number)args[0]).intValue();
                if (points < 0) {
                    return String.format("%s session points were removed from %s. (Undo move)", args);
                }
                return String.format("%s session points were added to %s.", args);
            }
            case "roundStarted": {
                return String.format("Round %d started.", args);
            }
            case "moveSubmitted": {
                return String.format("%s submitted move %s.", args);
            }
            case "roundFinished": {
                return String.format("Round %d finished.", args);
            }
            case "cricketFieldClosed": {
                return String.format("%s closed %s.", args);
            }
            case "cricketScoring": {
                int points = ((Number)args[1]).intValue();
                if (points < 0) {
                    return String.format("%s dropped %d score points. (Undoing %s move.)", args);
                }
                return String.format("%s received %d score points from %s.", args);
            }
            case "gameUndo": {
                return String.format("A move was taken back.", args);
            }
        }
        throw new UnsupportedOperationException(event);
    }

    public static interface Listener
    extends Serializable {
        public void onEvent(String var1, Serializable ... var2);
    }
}

