/*
 * Decompiled with CFR 0.152.
 */
package com.myapp.games.dartmaster;

import com.myapp.games.dartmaster.Events;
import com.myapp.games.dartmaster.Move;
import com.myapp.games.dartmaster.Player;
import com.myapp.games.dartmaster.util.EventListeners;
import com.myapp.games.dartmaster.util.GameAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class AbstractGame
implements Serializable {
    private static final long serialVersionUID = 1269813994270543500L;
    public static final int UNINITIALIZED = -9922;
    @Id
    @SequenceGenerator(name="Game_id_SeqGen", sequenceName="Game_Sequence", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="Game_id_SeqGen")
    private int id = -1;
    @Basic(optional=false)
    private int round;
    @Basic(optional=false)
    private int roundLimit = 20;
    @Basic(optional=false)
    private boolean isRunning = false;
    @Basic(optional=false)
    private int dartsPerMove = 3;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @OrderColumn(name="list_index")
    private final List<Player> players = new ArrayList<Player>();
    @Basic(optional=false)
    private int currentPlayerIndex = -9922;
    @Column(columnDefinition="TIMESTAMP(6)", updatable=false)
    private LocalDateTime creationDate;
    @Column(columnDefinition="TIMESTAMP(6)")
    private LocalDateTime lastSaveDate;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Player owner;
    @Transient
    protected transient EventListeners listeners;
    @Transient
    private transient Map<Integer, List<Player>> cachedCurrentPlacements;
    @Transient
    private transient Stack<Move> moveHistory;
    @Transient
    private transient Stack<Move> undoHistory;

    protected AbstractGame() {
        this.init();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (in != null) {
            in.defaultReadObject();
        }
        this.init();
    }

    private void init() {
        this.listeners = new EventListeners();
        this.moveHistory = new Stack();
        this.undoHistory = new Stack();
    }

    public void init(Player ... playersArray) {
        this.init(Arrays.asList(playersArray));
    }

    public void init(List<Player> playersList) {
        if (playersList == null || playersList.size() < 1 || playersList.size() > 20) {
            String count = playersList == null ? "null" : Integer.toString(playersList.size());
            throw new RuntimeException("illegal player count: " + count);
        }
        this.moveHistory.clear();
        this.undoHistory.clear();
        this.round = 1;
        this.players.clear();
        this.players.addAll(playersList);
        this.currentPlayerIndex = 0;
        this.dropCachedPlacements();
        this.initImpl();
        this.listeners.onEvent("gameStarted", new Serializable[]{AbstractGame.playerNames(playersList)});
        this.listeners.onEvent("roundStarted", Integer.valueOf(this.round));
        this.isRunning = true;
    }

    public void restartGame() {
        if (!this.isGameOver()) {
            throw new RuntimeException("cannot restart a game that is not over");
        }
        ArrayList<Player> copy = new ArrayList<Player>(this.players);
        copy.sort(Comparator.comparingInt(Player::getSessionScore));
        this.init(copy);
    }

    public Player getCurrentPlayer() {
        if (this.currentPlayerIndex >= this.getPlayers().size() || this.currentPlayerIndex < 0) {
            return null;
        }
        return this.players.get(this.currentPlayerIndex);
    }

    public void makeMove(Move move) {
        this.newMoveAction().act(this, move);
        this.moveHistory.push(move);
        if (!this.undoHistory.isEmpty()) {
            this.undoHistory.pop();
        }
    }

    protected abstract AbstractMoveAction newMoveAction();

    public void undoMove() {
        if (this.moveHistory.isEmpty()) {
            return;
        }
        Move lastMove = this.moveHistory.pop();
        this.undoHistory.push(lastMove);
        AbstractMoveAction moveAction = this.newMoveAction();
        moveAction.undo(this, lastMove);
    }

    protected Move getLastDoneMove() {
        if (this.moveHistory.isEmpty()) {
            return null;
        }
        return this.moveHistory.peek();
    }

    public Move getLastUndoneMove() {
        if (this.undoHistory.isEmpty()) {
            return null;
        }
        return this.undoHistory.peek();
    }

    public int getSessionRanking(Player player) {
        int ranking = 1;
        boolean anyScoreFound = false;
        for (Player other : this.players) {
            if (other.getSessionScore() > 0) {
                anyScoreFound = true;
            }
            if (other.equals(player) || other.getSessionScore() <= player.getSessionScore()) continue;
            ++ranking;
        }
        if (!anyScoreFound) {
            return 0;
        }
        return ranking;
    }

    public int getRound() {
        return this.round;
    }

    public String getRoundDisplayString() {
        if (this.isRoundLimitExceeded()) {
            return String.valueOf(this.roundLimit);
        }
        return String.valueOf(this.round);
    }

    public int getRoundLimit() {
        return this.roundLimit;
    }

    public void setRoundLimit(int roundLimit) {
        this.assertNotRunning();
        this.roundLimit = roundLimit;
    }

    protected abstract void initImpl();

    public final boolean isGameOver() {
        if (this.isRoundLimitExceeded()) {
            return true;
        }
        return this.isGameOverImpl();
    }

    private boolean isRoundLimitExceeded() {
        return this.roundLimit > 0 && this.round > this.roundLimit;
    }

    protected abstract boolean isGameOverImpl();

    public final Map<Integer, List<Player>> getCurrentPlacements() {
        if (this.cachedCurrentPlacements == null) {
            this.cachedCurrentPlacements = this.getCurrentPlacementsImpl();
        }
        return this.cachedCurrentPlacements;
    }

    protected abstract Map<Integer, List<Player>> getCurrentPlacementsImpl();

    public List<Player> getPlayers() {
        return Collections.unmodifiableList(this.players);
    }

    public static List<Integer> getScorePointsForEndGameRankings(int playerCount) {
        if (playerCount <= 2) {
            return Arrays.asList(1, 0);
        }
        ArrayList<Integer> rankingScorePoints = new ArrayList<Integer>(playerCount);
        for (int i = playerCount - 1; i >= 0; --i) {
            rankingScorePoints.add(i * 2 + 1);
        }
        return rankingScorePoints;
    }

    public void addEventListener(Events.Listener listener) {
        this.listeners.add(listener);
    }

    public static String playerNames(Collection<Player> players) {
        return players.stream().map(Player::getName).collect(Collectors.joining(", "));
    }

    public List<Player> getRemainingPlayersInRound() {
        int rem = this.players.size() - this.currentPlayerIndex;
        if (rem < 1) {
            return Collections.emptyList();
        }
        ArrayList<Player> copy = new ArrayList<Player>(rem);
        ListIterator<Player> iter = this.players.listIterator(this.currentPlayerIndex);
        while (iter.hasNext()) {
            copy.add(iter.next());
        }
        return copy;
    }

    public boolean isUndoPossible() {
        return this.moveHistory.size() > 0;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getDartsPerMove() {
        return this.dartsPerMove;
    }

    public void setDartsPerMove(int dartsPerMove) {
        this.assertNotRunning();
        this.dartsPerMove = dartsPerMove;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    protected final void assertNotRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot change setting when game is running");
        }
    }

    void dropCachedPlacements() {
        this.cachedCurrentPlacements = null;
    }

    public Events.Listener getListeners() {
        return this.listeners;
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public LocalDateTime getLastSaveDate() {
        return this.lastSaveDate;
    }

    public void setLastSaveDate(LocalDateTime lastSaveDate) {
        this.lastSaveDate = lastSaveDate;
    }

    public Player getOwner() {
        return this.owner;
    }

    public void setOwner(Player owner) {
        this.owner = owner;
    }

    public static abstract class AbstractMoveAction
    implements GameAction {
        @Override
        public final void act(AbstractGame g, Move move) {
            g.dropCachedPlacements();
            if (g.isGameOver()) {
                throw new RuntimeException("Game is over.");
            }
            if (!g.isRunning) {
                throw new RuntimeException("Game should be running.");
            }
            Player player = Objects.requireNonNull(g.getCurrentPlayer());
            move.setPlayer(player);
            move.setRound(g.round);
            g.listeners.onEvent("moveSubmitted", new Serializable[]{player.getName(), Move.serialize(move)});
            player.collectStatistics(move);
            this.actImpl(g, move);
            g.currentPlayerIndex++;
            if (g.currentPlayerIndex >= g.players.size()) {
                g.listeners.onEvent("roundFinished", Integer.valueOf(g.round));
                g.round++;
                if (!g.isGameOver()) {
                    g.currentPlayerIndex = 0;
                    g.listeners.onEvent("roundStarted", Integer.valueOf(g.round));
                }
            }
            if (g.isGameOver()) {
                g.isRunning = false;
                g.cachedCurrentPlacements = g.getCurrentPlacements();
                g.listeners.onEvent("gameOver", new Serializable[]{AbstractGame.playerNames((Collection)g.cachedCurrentPlacements.get(1))});
                List<Integer> pointsForRanks = AbstractGame.getScorePointsForEndGameRankings(g.players.size());
                g.cachedCurrentPlacements.forEach((rankIndex, players) -> {
                    int points = (Integer)pointsForRanks.get(rankIndex - 1);
                    if (points == 0) {
                        return;
                    }
                    players.forEach(p -> p.incrementSessionScore(points));
                    g.listeners.onEvent("gameSessionPointsAdded", new Serializable[]{Integer.valueOf(points), AbstractGame.playerNames(players)});
                });
            }
        }

        @Override
        public void undo(AbstractGame game, Move move) {
            Player previousPlayer;
            game.listeners.onEvent("gameUndo", new Serializable[0]);
            if (game.isGameOver()) {
                if (game.cachedCurrentPlacements == null) {
                    throw new RuntimeException("When the game is over, placements should be set!");
                }
                List<Integer> pointsForRanks = AbstractGame.getScorePointsForEndGameRankings(game.players.size());
                game.cachedCurrentPlacements.forEach((rankIndex, players) -> {
                    int points = (Integer)pointsForRanks.get(rankIndex - 1);
                    if (points == 0) {
                        return;
                    }
                    players.forEach(p -> p.incrementSessionScore(-points));
                    game.listeners.onEvent("gameSessionPointsAdded", new Serializable[]{Integer.valueOf(-points), AbstractGame.playerNames(players)});
                });
                game.isRunning = true;
            }
            if (Objects.equals(previousPlayer = move.getPlayer(), game.getCurrentPlayer())) {
                throw new RuntimeException("after undo, its " + previousPlayer.getName() + "'s turn.");
            }
            game.dropCachedPlacements();
            game.round = move.getRound();
            game.currentPlayerIndex = game.getPlayers().indexOf(previousPlayer);
            this.undoImpl(game, move);
        }

        protected abstract void actImpl(AbstractGame var1, Move var2);

        protected abstract void undoImpl(AbstractGame var1, Move var2);
    }
}

