/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.manifmerger;

import com.jayway.maven.plugins.android.manifmerger.ManifestMerger;
import com.jayway.maven.plugins.android.manifmerger.MergeStrategy;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class MergeStrategyR20
implements MergeStrategy {
    Log log;
    Method processMethod;
    Object merger;

    public MergeStrategyR20(Log log, File sdkPath) throws MojoExecutionException {
        File mergerLib = new File(sdkPath + "/tools/lib/manifmerger.jar");
        File sdkLibs = new File(sdkPath + "/tools/lib/sdklib.jar");
        URLClassLoader mlLoader = null;
        Class<?> manifestMergerClass = null;
        Class<?> mergerLogClass = null;
        try {
            mlLoader = new URLClassLoader(new URL[]{mergerLib.toURI().toURL()}, ManifestMerger.class.getClassLoader());
            manifestMergerClass = mlLoader.loadClass("com.android.manifmerger.ManifestMerger");
            log.debug((CharSequence)("ManifestMerger loaded " + manifestMergerClass));
            mergerLogClass = mlLoader.loadClass("com.android.manifmerger.MergerLog");
            log.debug((CharSequence)("ManifestMerger loaded " + mergerLogClass));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot create a correct URL from file " + mergerLib.getAbsolutePath());
        }
        catch (ClassNotFoundException e) {
            log.error((CharSequence)"Cannot find required class", (Throwable)e);
            throw new MojoExecutionException("Cannot find the required class", (Exception)e);
        }
        Class<?> stdSdkLogClass = null;
        try {
            URLClassLoader child = new URLClassLoader(new URL[]{sdkLibs.toURI().toURL()}, (ClassLoader)mlLoader);
            stdSdkLogClass = child.loadClass("com.android.sdklib.StdSdkLog");
            log.debug((CharSequence)("StdSdkLog loaded " + stdSdkLogClass));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot create a correct URL from file " + sdkLibs.getAbsolutePath());
        }
        catch (ClassNotFoundException e) {
            log.error((CharSequence)"Cannot find required class", (Throwable)e);
            throw new MojoExecutionException("Cannot find the required class", (Exception)e);
        }
        try {
            this.processMethod = manifestMergerClass.getMethod("process", File.class, File.class, File[].class);
        }
        catch (Exception e) {
            log.error((CharSequence)"Cannot find required method", (Throwable)e);
            throw new MojoExecutionException("Cannot find the required method", e);
        }
        try {
            Constructor<?> stdSdkLogConstructor = stdSdkLogClass.getDeclaredConstructors()[0];
            Object sdkLog = stdSdkLogConstructor.newInstance(new Object[0]);
            Method wrapSdkLogMethod = mergerLogClass.getMethod("wrapSdkLog", stdSdkLogClass.getInterfaces()[0]);
            Object iMergerLog = wrapSdkLogMethod.invoke(null, sdkLog.getClass().getInterfaces()[0].cast(sdkLog));
            Constructor<?> manifestMergerConstructor = manifestMergerClass.getDeclaredConstructors()[0];
            this.merger = manifestMergerConstructor.newInstance(iMergerLog);
        }
        catch (InvocationTargetException e) {
            log.error((CharSequence)"Cannot create the ManifestMerger object", e.getCause());
            throw new MojoExecutionException("Cannot create the ManifestMerger object", e.getCause());
        }
        catch (Exception e) {
            log.error((CharSequence)"Cannot create the ManifestMerger object", (Throwable)e);
            throw new MojoExecutionException("Cannot create the ManifestMerger object", e);
        }
    }

    @Override
    public boolean process(File mergedFile, File apkManifest, File[] libraryManifests) throws MojoExecutionException {
        try {
            return (Boolean)this.processMethod.invoke(this.merger, mergedFile, apkManifest, libraryManifests);
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Cannot merge the manifests", (Throwable)e);
            throw new MojoExecutionException("Cannot merge the manifests", e);
        }
    }
}

