/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.utils.transforms;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import java.util.List;

public class Standardization
implements Cloneable {
    private double[] mu;
    private double[] std;

    public void copy(Standardization rhs) {
        this.mu = (double[])rhs.mu.clone();
        this.std = (double[])rhs.std.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        Standardization clone = (Standardization)super.clone();
        clone.copy(this);
        return clone;
    }

    public Standardization() {
    }

    public Standardization(DataFrame batch) {
        this.query(batch);
    }

    public Standardization(List<double[]> batch) {
        this.query(batch);
    }

    public void fit(List<double[]> batch) {
        this.query(batch);
    }

    public void fit(DataFrame batch) {
        this.query(batch);
    }

    public double[] revert(double[] x) {
        double[] y = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = x[i] * this.std[i] + this.mu[i];
        }
        return y;
    }

    public double[] standardize(double[] x) {
        double[] y = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = (x[i] - this.mu[i]) / this.std[i];
        }
        return y;
    }

    protected void query(List<double[]> batch) {
        int j;
        double[] x;
        int i;
        int dimension = batch.get(0).length;
        int m = batch.size();
        this.mu = new double[dimension];
        this.std = new double[dimension];
        for (i = 0; i < dimension; ++i) {
            this.mu[i] = 0.0;
            this.std[i] = 0.0;
        }
        for (i = 0; i < m; ++i) {
            x = batch.get(i);
            for (j = 0; j < dimension; ++j) {
                int n = j;
                this.mu[n] = this.mu[n] + x[j];
            }
        }
        i = 0;
        while (i < dimension) {
            int n = i++;
            this.mu[n] = this.mu[n] / (double)m;
        }
        for (i = 0; i < m; ++i) {
            x = batch.get(i);
            for (j = 0; j < dimension; ++j) {
                int n = j;
                this.std[n] = this.std[n] + Math.pow(x[j] - this.mu[j], 2.0);
            }
        }
        i = 0;
        while (i < dimension) {
            int n = i++;
            this.std[n] = this.std[n] / (double)(m - 1);
        }
        for (i = 0; i < dimension; ++i) {
            this.std[i] = Math.sqrt(this.std[i]);
        }
    }

    protected void query(DataFrame batch) {
        int j;
        double[] x;
        DataRow tuple;
        int i;
        int dimension = batch.row(0).toArray().length;
        int m = batch.rowCount();
        this.mu = new double[dimension];
        this.std = new double[dimension];
        for (i = 0; i < dimension; ++i) {
            this.mu[i] = 0.0;
            this.std[i] = 0.0;
        }
        for (i = 0; i < m; ++i) {
            tuple = batch.row(i);
            x = tuple.toArray();
            for (j = 0; j < dimension; ++j) {
                int n = j;
                this.mu[n] = this.mu[n] + x[j];
            }
        }
        i = 0;
        while (i < dimension) {
            int n = i++;
            this.mu[n] = this.mu[n] / (double)m;
        }
        for (i = 0; i < m; ++i) {
            tuple = batch.row(i);
            x = tuple.toArray();
            for (j = 0; j < dimension; ++j) {
                int n = j;
                this.std[n] = this.std[n] + Math.pow(x[j] - this.mu[j], 2.0);
            }
        }
        i = 0;
        while (i < dimension) {
            int n = i++;
            this.std[n] = this.std[n] / (double)(m - 1);
        }
        for (i = 0; i < dimension; ++i) {
            this.std[i] = Math.sqrt(this.std[i]);
        }
    }
}

