/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.evaluators;

import com.github.chen0040.data.utils.TupleTwo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public class ConfusionMatrix
implements Serializable {
    private static final long serialVersionUID = 8446651320939507735L;
    private Map<TupleTwo<String, String>, Integer> matrix = new HashMap<TupleTwo<String, String>, Integer>();
    private Set<String> labels = new HashSet<String>();
    private transient ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incCount(String actual, String predicted) {
        this.readWriteLock.writeLock().lock();
        try {
            this.labels.add(actual);
            this.labels.add(predicted);
            TupleTwo<String, String> key = new TupleTwo<String, String>(actual, predicted);
            this.matrix.put(key, this.matrix.getOrDefault(key, 0) + 1);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public List<String> getLabels() {
        ArrayList<String> result = new ArrayList<String>();
        this.readWriteLock.readLock().lock();
        try {
            result.addAll(this.labels.stream().collect(Collectors.toList()));
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return result;
    }

    public void setLabels(List<String> labels) {
        this.readWriteLock.writeLock().lock();
        try {
            this.labels.clear();
            this.labels.addAll(labels);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public int getRowSum(String actual) {
        List<String> list = this.getLabels();
        int sum = 0;
        for (int i = 0; i < list.size(); ++i) {
            String predicted = list.get(i);
            sum += this.getCount(actual, predicted);
        }
        return sum;
    }

    public int getColumnSum(String predicted) {
        List<String> list = this.getLabels();
        int sum = 0;
        for (int i = 0; i < list.size(); ++i) {
            String actual = list.get(i);
            sum += this.getCount(actual, predicted);
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(String actual, String predicted) {
        int value = 0;
        this.readWriteLock.readLock().lock();
        try {
            value = this.matrix.getOrDefault(new TupleTwo<String, String>(actual, predicted), 0);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return value;
    }

    public void reset() {
        this.readWriteLock.writeLock().lock();
        try {
            this.matrix.clear();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public Map<TupleTwo<String, String>, Integer> getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Map<TupleTwo<String, String>, Integer> matrix) {
        this.matrix = matrix;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.readWriteLock = new ReentrantReadWriteLock();
    }
}

