/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.evaluators;

import java.io.Serializable;
import java.util.Map;

public class BinaryClassifierEvaluator
implements Serializable {
    private static final long serialVersionUID = -6175902545631384642L;
    private int truePositive = 0;
    private int trueNegative = 0;
    private int falsePositive = 0;
    private int falseNegative = 0;
    private double precision;
    private double fallout;
    private double accuracy;
    private double recall;
    private double specificity;
    private double sensitivity;
    private double misclassificationRate;
    private double f1Score;
    private int totalPredictedAnomalyDayCount;
    private int simulatedAnomalyTimeWindowCount;
    private Map<String, Integer> predictedAnomalyDayCountByDayOfWeek;
    private long startTime = 0L;
    private long endTime = 0L;
    private boolean isValid = false;

    public BinaryClassifierEvaluator() {
    }

    public BinaryClassifierEvaluator(int truePositive, int trueNegative, int falsePositive, int falseNegative) {
        this.truePositive = truePositive;
        this.trueNegative = trueNegative;
        this.falsePositive = falsePositive;
        this.falseNegative = falseNegative;
        this.update();
    }

    public void reset() {
        this.trueNegative = 0;
        this.truePositive = 0;
        this.falsePositive = 0;
        this.falseNegative = 0;
        this.isValid = false;
        this.precision = 0.0;
        this.recall = 0.0;
        this.specificity = 0.0;
        this.misclassificationRate = 0.0;
        this.f1Score = 0.0;
    }

    public void evaluate(boolean actual, boolean predicted) {
        if (predicted) {
            this.assertTruePositive(actual, predicted);
        } else {
            this.assertTrueNegative(actual, predicted);
        }
    }

    private void assertTruePositive(boolean actual, boolean predicted) {
        if (actual == predicted) {
            ++this.truePositive;
        } else {
            ++this.falsePositive;
        }
    }

    private void assertTrueNegative(boolean actual, boolean predicted) {
        if (actual == predicted) {
            ++this.trueNegative;
        } else {
            ++this.falseNegative;
        }
    }

    private void update() {
        this.precision = (double)this.truePositive / (double)(this.truePositive + this.falsePositive);
        this.sensitivity = (double)this.truePositive / (double)(this.truePositive + this.falseNegative);
        this.specificity = (double)this.trueNegative / (double)(this.trueNegative + this.falsePositive);
        this.recall = (double)this.truePositive / (double)(this.truePositive + this.falseNegative);
        this.accuracy = (double)(this.truePositive + this.trueNegative) / (double)(this.truePositive + this.trueNegative + this.falsePositive + this.falseNegative);
        this.fallout = (double)this.falsePositive / (double)(this.falsePositive + this.trueNegative);
        this.misclassificationRate = (double)(this.falsePositive + this.falseNegative) / (double)(this.truePositive + this.trueNegative + this.falsePositive + this.falseNegative);
        this.f1Score = 2.0 * (this.precision * this.recall) / (this.precision + this.recall);
        this.isValid = true;
    }

    public void setTotalPredictedAnomalyDayCount(int totalPredictedAnomalyDayCount) {
        this.totalPredictedAnomalyDayCount = totalPredictedAnomalyDayCount;
    }

    public int getTotalPredictedAnomalyDayCount() {
        return this.totalPredictedAnomalyDayCount;
    }

    public void setSimulatedAnomalyTimeWindowCount(int simulatedAnomalyTimeWindowCount) {
        this.simulatedAnomalyTimeWindowCount = simulatedAnomalyTimeWindowCount;
    }

    public int getSimulatedAnomalyTimeWindowCount() {
        return this.simulatedAnomalyTimeWindowCount;
    }

    public void setPredictedAnomalyDayCountByDayOfWeek(Map<String, Integer> predictedAnomalyDayCountByDayOfWeek) {
        this.predictedAnomalyDayCountByDayOfWeek = predictedAnomalyDayCountByDayOfWeek;
    }

    public Map<String, Integer> getPredictedAnomalyDayCountByDayOfWeek() {
        return this.predictedAnomalyDayCountByDayOfWeek;
    }

    public int getTruePositive() {
        return this.truePositive;
    }

    public void setTruePositive(int truePositive) {
        this.truePositive = truePositive;
    }

    public int getTrueNegative() {
        return this.trueNegative;
    }

    public void setTrueNegative(int trueNegative) {
        this.trueNegative = trueNegative;
    }

    public int getFalsePositive() {
        return this.falsePositive;
    }

    public void setFalsePositive(int falsePositive) {
        this.falsePositive = falsePositive;
    }

    public int getFalseNegative() {
        return this.falseNegative;
    }

    public void setFalseNegative(int falseNegative) {
        this.falseNegative = falseNegative;
    }

    public double getPrecision() {
        if (!this.isValid) {
            this.update();
        }
        return this.precision;
    }

    public void setPrecision(double precision) {
        this.precision = precision;
    }

    public double getAccuracy() {
        if (!this.isValid) {
            this.update();
        }
        return this.accuracy;
    }

    public void setAccuracy(double accuracy) {
        this.accuracy = accuracy;
    }

    public double getRecall() {
        if (!this.isValid) {
            this.update();
        }
        return this.recall;
    }

    public double getSpecificity() {
        if (!this.isValid) {
            this.update();
        }
        return this.specificity;
    }

    public double getF1Score() {
        if (!this.isValid) {
            this.update();
        }
        return this.f1Score;
    }

    public double getSensitivity() {
        if (!this.isValid) {
            this.update();
        }
        return this.sensitivity;
    }

    public void setSensitivity(double sensitivity) {
        this.sensitivity = sensitivity;
    }

    public double getMisclassificationRate() {
        if (!this.isValid) {
            this.update();
        }
        return this.misclassificationRate;
    }

    public void setMisclassificationRate(double misclassificationRate) {
        this.misclassificationRate = misclassificationRate;
    }

    public double getFallout() {
        return this.fallout;
    }

    public void report() {
        System.out.println(this.getSummary());
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Training accuracy: ").append(this.getAccuracy());
        sb.append("\nTraining mis-classification: ").append(this.getMisclassificationRate());
        sb.append("\nTraining f1-score: ").append(this.getF1Score());
        sb.append("\nDuration (seconds): ").append(this.durationInSeconds());
        return sb.toString();
    }

    public void startTimer() {
        this.startTime = System.currentTimeMillis();
    }

    public void stopTimer() {
        this.endTime = System.currentTimeMillis();
    }

    public long durationInSeconds() {
        return (this.endTime - this.startTime) / 1000L;
    }
}

