/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeExportTasksRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeExportTasksRequestMarshaller
implements Marshaller<Request<DescribeExportTasksRequest>, DescribeExportTasksRequest> {
    public Request<DescribeExportTasksRequest> marshall(DescribeExportTasksRequest describeExportTasksRequest) {
        if (describeExportTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeExportTasksRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeExportTasks");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeExportTasksRequest.getExportTaskIdentifier() != null) {
            request.addParameter("ExportTaskIdentifier", StringUtils.fromString((String)describeExportTasksRequest.getExportTaskIdentifier()));
        }
        if (describeExportTasksRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)describeExportTasksRequest.getSourceArn()));
        }
        if (!describeExportTasksRequest.getFilters().isEmpty() || !((SdkInternalList)describeExportTasksRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeExportTasksRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeExportTasksRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeExportTasksRequest.getMarker()));
        }
        if (describeExportTasksRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromString((String)describeExportTasksRequest.getMaxRecords()));
        }
        return request;
    }
}

